/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.socialmedia.knowledgebase.factory.method;

import com.agilemind.commons.mvc.controllers.Controller;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.socialmedia.controllers.socialmentions.AccountCreationInfo;
import com.agilemind.socialmedia.controllers.socialmentions.actions.SendDirectLinkedInMessageAction;
import com.agilemind.socialmedia.controllers.socialmentions.actions.facebook.RateAction;
import com.agilemind.socialmedia.controllers.socialmentions.actions.linkedin.LinkedInCommentAction;
import com.agilemind.socialmedia.controllers.socialmentions.actions.linkedin.LinkedInShareAction;
import com.agilemind.socialmedia.controllers.socialmentions.dialogs.linkedin.LinkedInLikeMessageDialogController;
import com.agilemind.socialmedia.data.BuzzBundleProject;
import com.agilemind.socialmedia.data.Persona;
import com.agilemind.socialmedia.data.entity.Message;
import com.agilemind.socialmedia.io.data.enums.MessageType;
import com.agilemind.socialmedia.io.data.enums.ReplyStatus;
import com.agilemind.socialmedia.io.data.enums.ServiceType;
import com.agilemind.socialmedia.knowledgebase.factory.method.AbstractServiceTypeFactory;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;

public class LinkedInFactory
extends AbstractServiceTypeFactory {
    @Override
    public AccountCreationInfo createAccountCreationInfo(Persona persona, UnicodeURL unicodeURL, BuzzBundleProject buzzBundleProject) {
        return this.a(persona, ServiceType.LINKED_IN, unicodeURL, buzzBundleProject);
    }

    @Override
    public List<Action> createMessageActions(Controller controller, Message message) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        if (message.getMessageType() == MessageType.LINKED_IN_POST) {
            arrayList.add((Action)((Object)new RateAction(controller, LinkedInLikeMessageDialogController.class, ServiceType.LINKED_IN, message)));
        }
        arrayList.add((Action)((Object)new SendDirectLinkedInMessageAction(controller, message)));
        arrayList.addAll(this.createReplyActions(controller, message));
        return arrayList;
    }

    @Override
    public List<Action> createReplyActions(Controller controller, Message message) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        ReplyStatus replyStatus = message.getReplyStatus();
        if (replyStatus != null) {
            arrayList.add((Action)((Object)new LinkedInCommentAction(controller, message, replyStatus)));
            arrayList.add((Action)((Object)new LinkedInShareAction(controller, message)));
        }
        return arrayList;
    }
}

