/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.sitescan.data.audit.factor.domain;

import com.agilemind.commons.application.modules.audit.AuditStatusType;
import com.agilemind.commons.io.searchengine.analyzers.SearchEngineFactorsList;
import com.agilemind.commons.io.searchengine.analyzers.data.DomainInfo;
import com.agilemind.commons.io.searchengine.analyzers.data.FactorType;
import com.agilemind.commons.io.searchengine.analyzers.data.IPopularityMap;
import com.agilemind.commons.io.searchengine.analyzers.data.ISearchEngineFactor;
import com.agilemind.sitescan.data.audit.factor.domain.DomainAuditFactor;
import com.agilemind.sitescan.data.audit.factor.domain.DomainAuditResult;

public class FixedProtocolVersionsAuditFactor
implements DomainAuditFactor {
    @Override
    public DomainAuditResult getDomainAuditResult(IPopularityMap iPopularityMap) {
        ISearchEngineFactor iSearchEngineFactor = iPopularityMap.getFactor((FactorType)SearchEngineFactorsList.DOMAIN_INFO_FACTOR_TYPE);
        if (iSearchEngineFactor == null) {
            return new DomainAuditResult(AuditStatusType.NOT_YET_CHECKED, false);
        }
        DomainInfo.ProtocolResult protocolResult = ((DomainInfo)iSearchEngineFactor.getFactorValue()).getFixedProtocol();
        if (protocolResult != null) {
            switch (protocolResult) {
                case FIXED: {
                    return new DomainAuditResult(AuditStatusType.OK, false);
                }
                case NOT_FIXED: {
                    return new DomainAuditResult(AuditStatusType.WARNING, true);
                }
                case SSL_ERROR: {
                    return new DomainAuditResult(AuditStatusType.ERROR, true);
                }
            }
        }
        return new DomainAuditResult(AuditStatusType.N_A, false);
    }
}

