/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.sitescan.data.audit.factor.pages;

import com.agilemind.commons.application.modules.audit.AuditStatusType;
import com.agilemind.commons.io.searchengine.analyzers.SearchEngineFactorsList;
import com.agilemind.sitescan.data.HttpResponseCodeGroup;
import com.agilemind.sitescan.data.audit.factor.pages.FactorDependPagesAuditFactor;
import com.agilemind.sitescan.data.audit.factor.pages.PagesAuditResult;
import com.agilemind.websiteauditor.data.PageContainer;
import com.agilemind.websiteauditor.data.WebsiteAuditorPage;
import com.agilemind.websiteauditor.data.resourcesource.ResourceSource;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PagesWithExcessiveNumberOfLinksAuditFactor
extends FactorDependPagesAuditFactor {
    public static final int MAX_NORMAL_LINKS_COUNT = 100;

    public PagesWithExcessiveNumberOfLinksAuditFactor() {
        super(SearchEngineFactorsList.EXTRA_PAGE_INFO_FACTOR_TYPE);
    }

    @Override
    public PagesAuditResult getResult(List<WebsiteAuditorPage> list) {
        Predicate<PageContainer> predicate = PagesWithExcessiveNumberOfLinksAuditFactor::a;
        List<WebsiteAuditorPage> list2 = list.stream().filter(PagesWithExcessiveNumberOfLinksAuditFactor::a).filter(arg_0 -> PagesWithExcessiveNumberOfLinksAuditFactor.a(predicate, arg_0)).collect(Collectors.toList());
        return new PagesAuditResult(list2.isEmpty() ? AuditStatusType.OK : AuditStatusType.INFO, list2);
    }

    private static boolean a(Predicate predicate, WebsiteAuditorPage websiteAuditorPage) {
        return websiteAuditorPage.getResources().getList().stream().filter(predicate).count() > 100L;
    }

    private static boolean a(WebsiteAuditorPage websiteAuditorPage) {
        return websiteAuditorPage.getHttpStatusCode() != null && !HttpResponseCodeGroup.RES_3XX.accept(websiteAuditorPage.getHttpStatusCode());
    }

    private static boolean a(PageContainer pageContainer) {
        return ((ResourceSource)pageContainer.getResourceSource()).getResourceSourceType().isLinkType();
    }
}

