/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.sitescan.data.audit.factor.resources;

import com.agilemind.commons.application.modules.audit.AuditStatusType;
import com.agilemind.commons.application.modules.io.searchengine.data.SearchEngineFactor;
import com.agilemind.commons.io.searchengine.analyzers.SearchEngineFactorsList;
import com.agilemind.commons.io.searchengine.analyzers.data.FactorType;
import com.agilemind.commons.io.searchengine.robots.data.RobotsResult;
import com.agilemind.commons.io.searchengine.robots.data.RobotsValue;
import com.agilemind.sitescan.data.audit.factor.resources.FactorDependResourcesAuditFactor;
import com.agilemind.sitescan.data.audit.factor.resources.ResourcesAuditResult;
import com.agilemind.websiteauditor.data.Resource;
import com.agilemind.websiteauditor.util.WebsiteAuditorStringKey;
import java.util.ArrayList;
import java.util.List;

public class ResourcesRestrictedFromIndexingAuditFactor
extends FactorDependResourcesAuditFactor {
    public ResourcesRestrictedFromIndexingAuditFactor() {
        super(SearchEngineFactorsList.ROBOTS_FACTOR_TYPE);
    }

    @Override
    public ResourcesAuditResult getResult(List<Resource> list) {
        boolean bl = ResourcesAuditResult.b;
        int n2 = 0;
        int n3 = 0;
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        for (Resource resource : list) {
            RobotsResult robotsResult;
            if (resource.isExternal() && !bl) continue;
            ++n3;
            SearchEngineFactor searchEngineFactor = resource.getPopularityMap().getFactor((FactorType)SearchEngineFactorsList.ROBOTS_FACTOR_TYPE);
            if (searchEngineFactor == null && !bl || (robotsResult = (RobotsResult)searchEngineFactor.getFactorValue()) == null && !bl) continue;
            RobotsValue robotsValue = robotsResult.getStatus();
            if (robotsValue == RobotsValue.DISALLOW || robotsValue == RobotsValue.PARTIALLY_DISALLOW) {
                arrayList.add(resource);
                if (robotsValue == RobotsValue.DISALLOW) {
                    ++n2;
                }
            }
            if (!bl) continue;
        }
        ResourcesAuditResult resourcesAuditResult = new ResourcesAuditResult(this.a(n3, arrayList.size(), n2), arrayList);
        if (WebsiteAuditorStringKey.b != 0) {
            ResourcesAuditResult.b = !bl;
        }
        return resourcesAuditResult;
    }

    private AuditStatusType a(int n2, int n3, int n4) {
        if (n3 == 0) {
            return AuditStatusType.OK;
        }
        if (n2 == n4) {
            return AuditStatusType.ERROR;
        }
        if (100.0 / (double)n2 * (double)n4 > 90.0) {
            return AuditStatusType.WARNING;
        }
        return AuditStatusType.INFO;
    }
}

