/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.socialmedia.report.period;

import com.agilemind.commons.util.DateUtil;
import com.agilemind.commons.util.Interval;
import com.agilemind.socialmedia.report.period.IPeriodSettings;
import com.agilemind.socialmedia.report.period.PeriodIntervalType;
import com.agilemind.socialmedia.util.SocialMediaStringKey;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodUtil {
    private static final Logger a;
    static final boolean b;

    public static Interval<Date> calcInterval(Date date, IPeriodSettings iPeriodSettings) {
        return PeriodUtil.calcInterval(date, iPeriodSettings.getType(), iPeriodSettings.getInterval());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Interval<Date> calcInterval(Date date, PeriodIntervalType periodIntervalType, Interval<Date> interval) {
        switch (periodIntervalType) {
            case ALL_TIME: {
                return null;
            }
            case CUSTOM: {
                return PeriodUtil.fixDayInterval(interval);
            }
        }
        return PeriodUtil.fixDayInterval(PeriodUtil.a(date, periodIntervalType));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Interval<Date> calcComparisonInterval(Date date, IPeriodSettings iPeriodSettings) {
        switch (iPeriodSettings.getComparisonType()) {
            case CUSTOM: {
                return PeriodUtil.fixDayInterval(iPeriodSettings.getComparisonInterval());
            }
            case PREVIOUS_PERIOD: {
                return PeriodUtil.calcPreviousComparisonInterval(iPeriodSettings.getType(), PeriodUtil.calcInterval(date, iPeriodSettings));
            }
        }
        throw new IllegalArgumentException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Interval<Date> calcPreviousComparisonInterval(PeriodIntervalType periodIntervalType, Interval<Date> interval) {
        switch (periodIntervalType) {
            case CUSTOM: 
            case YESTERDAY: 
            case LAST_7_DAYS: 
            case LAST_30_DAYS: {
                return PeriodUtil.fixDayInterval(PeriodUtil.a(interval));
            }
            case LAST_WEEK: {
                return PeriodUtil.fixDayInterval(PeriodUtil.b((Date)interval.from()));
            }
            case LAST_MONTH: {
                return PeriodUtil.fixDayInterval(PeriodUtil.a((Date)interval.from()));
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Interval<Date> a(Date date, PeriodIntervalType periodIntervalType) {
        long l2;
        long l3;
        boolean bl = PeriodIntervalType.e;
        if (!b && !periodIntervalType.isSupported()) {
            throw new AssertionError();
        }
        switch (periodIntervalType) {
            case ALL_TIME: {
                return null;
            }
            case YESTERDAY: {
                l2 = l3 = DateUtil.prevDay((long)date.getTime());
                if (!bl) break;
            }
            case LAST_7_DAYS: {
                l3 = DateUtil.prevDay((long)date.getTime());
                l2 = DateUtil.moveDay((long)date.getTime(), (int)-7);
                if (!bl) break;
            }
            case LAST_WEEK: {
                return PeriodUtil.b(date);
            }
            case LAST_30_DAYS: {
                l3 = DateUtil.prevDay((long)date.getTime());
                l2 = DateUtil.moveDay((long)date.getTime(), (int)-30);
                if (!bl) break;
            }
            case LAST_MONTH: {
                return PeriodUtil.a(date);
            }
            case CUSTOM: {
                throw new IllegalArgumentException();
            }
            default: {
                return null;
            }
        }
        return Interval.create((Object)new Date(l2), (Object)new Date(l3));
    }

    private static Interval<Date> a(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.add(2, -1);
        Date date2 = calendar.getTime();
        calendar.set(5, calendar.getActualMaximum(5));
        return Interval.create((Object)date2, (Object)calendar.getTime());
    }

    private static Interval<Date> b(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, 1);
        calendar.add(3, -1);
        Date date2 = calendar.getTime();
        calendar.set(7, calendar.getActualMaximum(7));
        return Interval.create((Object)date2, (Object)calendar.getTime());
    }

    private static Interval<Date> a(Interval<Date> interval) {
        long l2 = ((Date)interval.to()).getTime() - ((Date)interval.from()).getTime();
        Calendar calendar = Calendar.getInstance();
        DateUtil.setStartDayCalendar((Calendar)calendar, (Date)((Date)interval.from()));
        long l3 = calendar.getTimeInMillis() - 1L;
        return Interval.create((Object)new Date(l3 - l2), (Object)new Date(l3));
    }

    public static Interval<Date> fixDayInterval(Interval<Date> interval) {
        Interval interval2;
        block4: {
            boolean bl;
            block6: {
                block5: {
                    boolean bl2 = PeriodIntervalType.e;
                    Calendar calendar = Calendar.getInstance();
                    DateUtil.setStartDayCalendar((Calendar)calendar, (Date)((Date)interval.from()));
                    Date date = calendar.getTime();
                    DateUtil.setStartDayCalendar((Calendar)calendar, (Date)((Date)interval.to()));
                    interval2 = Interval.create((Object)date, (Object)new Date(calendar.getTimeInMillis() + 86400000L - 1L));
                    if (!SocialMediaStringKey.b) break block4;
                    if (!bl2) break block5;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
            PeriodIntervalType.e = bl;
        }
        return interval2;
    }

    public static void main(String[] stringArray) {
        block4: {
            boolean bl;
            block6: {
                block5: {
                    boolean bl2 = PeriodIntervalType.e;
                    Date date = DateUtil.createDate((int)2015, (int)10, (int)20, (int)0, (int)0);
                    Date date2 = DateUtil.createDate((int)2015, (int)10, (int)10, (int)0, (int)0);
                    Interval interval = Interval.create((Object)date2, (Object)date);
                    a.info(interval.toString());
                    long l2 = ((Date)interval.to()).getTime() - ((Date)interval.from()).getTime();
                    long l3 = DateUtil.prevDay((long)((Date)interval.from()).getTime());
                    a.info(Interval.create((Object)new Date(l3 - l2), (Object)new Date(l3)).toString());
                    if (!bl2) break block4;
                    if (!SocialMediaStringKey.b) break block5;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
            SocialMediaStringKey.b = bl;
        }
    }

    static {
        boolean bl = !PeriodUtil.class.desiredAssertionStatus();
        b = bl;
        a = LoggerFactory.getLogger(PeriodUtil.class);
    }
}

