/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.ranktracker.data;

import com.agilemind.commons.data.field.Age;
import com.agilemind.commons.io.searchengine.analyzers.data.AlexaPopularityResult;
import com.agilemind.commons.io.searchengine.analyzers.parsers.IFactorParser;
import com.agilemind.commons.util.MathUtil;
import com.agilemind.ranktracker.data.AbstractKeyword;
import com.agilemind.ranktracker.data.PageDifficultyData;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeywordDifficultyUtils {
    private static final int[] a = new int[]{1, 20, 50, 100, 500, 1000, 5000, 10000, 20000, 50000};
    private static final int[] b = new int[]{1, 5, 10, 20, 40, 60, 75, 90, 95, 100};
    private static final double[] c = new double[]{0.0, 20.0, 40.0, 70.0, 100.0};
    private static final double[] d = new double[]{0.0, 20.0, 50.0, 90.0, 100.0};
    private static final int[] e = new int[]{1, 1000, 10000, 100000, 500000};
    private static final int[] f = new int[]{100, 90, 60, 30, 0};
    private static final long[] g = new long[]{0L, 50L, 1000L, 5000L, 10000L, 20000L};
    private static final int[] h = new int[]{0, 10, 40, 70, 90, 100};
    private static final int[] i = new int[]{0, 12, 36, 60, 120};
    private static final int[] j = new int[]{0, 30, 70, 90, 100};
    private static final Logger k = LoggerFactory.getLogger(KeywordDifficultyUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double calculatePageDifficultyScore(PageDifficultyData pageDifficultyData) {
        double d2 = 0.0;
        try {
            d2 += KeywordDifficultyUtils.a(pageDifficultyData);
            d2 += KeywordDifficultyUtils.b(pageDifficultyData);
            d2 += KeywordDifficultyUtils.c(pageDifficultyData);
            d2 += KeywordDifficultyUtils.d(pageDifficultyData);
            d2 += KeywordDifficultyUtils.e(pageDifficultyData);
            if (l) return d2;
            if ((d2 += KeywordDifficultyUtils.f(pageDifficultyData)) < 100.0) return d2;
            throw new AssertionError(d2);
        }
        catch (Throwable throwable) {
            k.error("", throwable);
        }
        return d2;
    }

    private static double a(PageDifficultyData pageDifficultyData) {
        if (pageDifficultyData.getPageReferencesSites() == null || pageDifficultyData.getPageReferencesSites() == 0) {
            return 0.0;
        }
        int n2 = pageDifficultyData.getPageReferencesSites();
        double d2 = MathUtil.getPoints((int)n2, (int[])a, (int[])b);
        return d2 * 80.0 / 300.0;
    }

    private static double b(PageDifficultyData pageDifficultyData) {
        if (pageDifficultyData.getDomainReferencesSites() == null || pageDifficultyData.getDomainReferencesSites() == 0) {
            return 0.0;
        }
        int n2 = pageDifficultyData.getDomainReferencesSites();
        double d2 = MathUtil.getPoints((int)n2, (int[])a, (int[])b);
        return d2 * 100.0 / 300.0;
    }

    private static double c(PageDifficultyData pageDifficultyData) {
        assert (pageDifficultyData != null);
        if (pageDifficultyData.getOptimizationRate() == null || pageDifficultyData.getOptimizationRate() == -1.0) {
            return 0.0;
        }
        double d2 = pageDifficultyData.getOptimizationRate();
        double d3 = MathUtil.getPoints((double)d2, (double[])c, (double[])d);
        return d3 * 50.0 / 300.0;
    }

    private static double d(PageDifficultyData pageDifficultyData) {
        AlexaPopularityResult alexaPopularityResult = pageDifficultyData.getAlexaPopularity();
        if (alexaPopularityResult == null) {
            return 0.0;
        }
        int n2 = alexaPopularityResult.getGlobalRank();
        if (n2 < 1 || n2 == Integer.MAX_VALUE) {
            return 0.0;
        }
        double d2 = MathUtil.getPoints((int)n2, (int[])e, (int[])f);
        return d2 * 40.0 / 300.0;
    }

    private static double e(PageDifficultyData pageDifficultyData) {
        double d2;
        block5: {
            Long l2;
            block4: {
                l2 = pageDifficultyData.getSocialSignals();
                if (l2 == null) {
                    return 0.0;
                }
                if (l2 <= Integer.MAX_VALUE) break block4;
                d2 = 100.0;
                if (!AbstractKeyword.c) break block5;
            }
            d2 = MathUtil.getPoints((long)l2, (long[])g, (int[])h);
        }
        return d2 * 20.0 / 300.0;
    }

    private static double f(PageDifficultyData pageDifficultyData) {
        assert (pageDifficultyData != null);
        Date date = pageDifficultyData.getDomainAge();
        if (date == null || date.equals(IFactorParser.NA_DATE)) {
            return 0.0;
        }
        Age age = new Age(date);
        int n2 = age.getMonths();
        double d2 = MathUtil.getPoints((int)(n2 += age.getYears() * 12), (int[])i, (int[])j);
        return d2 * 10.0 / 300.0;
    }
}

