/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.ranktracker.report.data.widget.data.project;

import com.agilemind.commons.application.modules.factors.data.DomainStrengthUtil;
import com.agilemind.commons.application.modules.io.searchengine.data.KEI;
import com.agilemind.commons.application.modules.io.searchengine.data.PopularityHistoryMap;
import com.agilemind.commons.application.modules.io.searchengine.data.PopularityMap;
import com.agilemind.commons.application.modules.io.searchengine.data.UniversalSearchTypesList;
import com.agilemind.commons.application.modules.widget.core.IWidgetReportSettings;
import com.agilemind.commons.application.modules.widget.util.RecordAnalyzeUtil;
import com.agilemind.commons.application.modules.widget.util.to.GraphPeriod;
import com.agilemind.commons.gui.chart.ChartColorGetter;
import com.agilemind.commons.gui.chart.data.XYChartData;
import com.agilemind.commons.gui.chart.data.XYDataset;
import com.agilemind.commons.gui.util.UiUtil;
import com.agilemind.commons.io.searchengine.analyzers.data.IPopularityMap;
import com.agilemind.commons.io.searchengine.keyword.collectors.data.SearchVolumeRange;
import com.agilemind.commons.io.searchengine.searchengines.data.MajorSearchEngineType;
import com.agilemind.commons.io.searchengine.searchengines.data.UniversalSearchType;
import com.agilemind.commons.io.searchengine.searchengines.type.SearchEngineType;
import com.agilemind.commons.io.searchengine.util.SearchEngineTypeComparator;
import com.agilemind.commons.io.utils.BinaryFile;
import com.agilemind.commons.util.DateUtil;
import com.agilemind.commons.util.MathUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.Util;
import com.agilemind.ranktracker.data.CompareAgainst;
import com.agilemind.ranktracker.data.Competitor;
import com.agilemind.ranktracker.data.ICompareAgainst;
import com.agilemind.ranktracker.data.IKeywordGroup;
import com.agilemind.ranktracker.data.IKeywordPosition;
import com.agilemind.ranktracker.data.ILandingPage;
import com.agilemind.ranktracker.data.Keyword;
import com.agilemind.ranktracker.data.KeywordPosition;
import com.agilemind.ranktracker.data.KeywordPositionsList;
import com.agilemind.ranktracker.data.KeywordTrackingSettings;
import com.agilemind.ranktracker.data.KeywordsList;
import com.agilemind.ranktracker.data.KeywordsUtil;
import com.agilemind.ranktracker.data.PageVisits;
import com.agilemind.ranktracker.data.PageVisitsList;
import com.agilemind.ranktracker.data.RankTrackerProject;
import com.agilemind.ranktracker.data.SessionsList;
import com.agilemind.ranktracker.report.data.widget.UniversalResult;
import com.agilemind.ranktracker.report.data.widget.ValueDifference;
import com.agilemind.ranktracker.report.data.widget.data.IKeywordInfo;
import com.agilemind.ranktracker.report.data.widget.data.KeywordMetricsByKeywordGroupWidgetService;
import com.agilemind.ranktracker.report.data.widget.data.KeywordMetricsByLandingPageWidgetService;
import com.agilemind.ranktracker.report.data.widget.data.KeywordMovedUpDownWidgetService;
import com.agilemind.ranktracker.report.data.widget.data.KeywordRanksCompetitorsWidgetService;
import com.agilemind.ranktracker.report.data.widget.data.KeywordRanksSummaryWidgetService;
import com.agilemind.ranktracker.report.data.widget.data.KeywordRanksWidgetService;
import com.agilemind.ranktracker.report.data.widget.data.KeywordsSummaryWidgetService;
import com.agilemind.ranktracker.report.data.widget.data.RankTrackerWidgetService;
import com.agilemind.ranktracker.report.data.widget.data.RankingPagesWidgetService;
import com.agilemind.ranktracker.report.data.widget.data.SessionsWidgetService;
import com.agilemind.ranktracker.report.data.widget.data.VisibilityBySearchEngineWidgetService;
import com.agilemind.ranktracker.report.data.widget.data.VisibilityProgressGraphWidgetData;
import com.agilemind.ranktracker.report.data.widget.data.project.KeywordInfo;
import com.agilemind.ranktracker.report.data.widget.data.project.g;
import com.agilemind.ranktracker.report.data.widget.data.project.h;
import com.agilemind.ranktracker.report.data.widget.data.project.i;
import com.agilemind.ranktracker.report.data.widget.data.project.j;
import com.agilemind.ranktracker.util.RankTrackerStringKey;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class KeywordsWidgetProjectService
implements KeywordRanksWidgetService,
KeywordRanksCompetitorsWidgetService,
KeywordMovedUpDownWidgetService<Competitor>,
KeywordRanksSummaryWidgetService<Competitor>,
KeywordsSummaryWidgetService<Competitor>,
KeywordMetricsByKeywordGroupWidgetService,
KeywordMetricsByLandingPageWidgetService,
VisibilityBySearchEngineWidgetService<Competitor>,
VisibilityProgressGraphWidgetData<Competitor>,
RankingPagesWidgetService,
RankTrackerWidgetService,
SessionsWidgetService {
    private RankTrackerProject a;
    private ChartColorGetter<SearchEngineType> b;
    private KeywordTrackingSettings c;
    private List<Keyword> d;
    public static int e;

    public KeywordsWidgetProjectService(IWidgetReportSettings iWidgetReportSettings, RankTrackerProject rankTrackerProject) {
        this.a = rankTrackerProject;
        this.b = new ChartColorGetter((Paint[])UiUtil.PREDEFINED_COLORS);
        this.c = rankTrackerProject.getKeywords().getKeywordTrackingSettings();
        this.d = RecordAnalyzeUtil.filterByTags((Iterable)((Object)rankTrackerProject.getKeywords().getKeywordsList()), (List)iWidgetReportSettings.getTags());
    }

    @Override
    public String getProjectShortName() {
        return this.a.getShortName();
    }

    @Override
    public BinaryFile getProjectThumbnail() {
        return this.a.getDomainThumbnail();
    }

    @Override
    public UnicodeURL getProjectUrl() {
        return this.a.getDomain();
    }

    @Override
    public String getProjectTitle() {
        return this.a.getProjectUrlTitle();
    }

    @Override
    public List<SearchEngineType> getSearchEngines() {
        ArrayList<SearchEngineType> arrayList = new ArrayList<SearchEngineType>(this.a.getUseSearchEngineList().getList());
        Collections.sort(arrayList, new SearchEngineTypeComparator());
        return arrayList;
    }

    @Override
    public List<IKeywordInfo> getKeywords() {
        boolean bl = this.c.isTrackMultiplePositions();
        List list = Util.transform(this.d, arg_0 -> this.a(bl, arg_0));
        Collections.sort(list, KeywordsWidgetProjectService::a);
        return list;
    }

    @Override
    public int getKeywordsCount() {
        return this.d.size();
    }

    @Override
    public int getSearchEnginesCount() {
        return this.a.getUseSearchEngineList().size();
    }

    public List<Competitor> getCompetitors() {
        return Util.filter((Iterable)((Object)this.a.getCompetitorsList()), (Predicate[])new Predicate[]{Competitor::isIncludeInReport});
    }

    private boolean a(List<SearchEngineType> list, @Nullable Competitor competitor, ICompareAgainst iCompareAgainst) {
        int n2 = e;
        for (SearchEngineType searchEngineType : list) {
            if (this.a(searchEngineType, competitor, iCompareAgainst)) {
                return true;
            }
            if (n2 == 0) continue;
        }
        return false;
    }

    private boolean a(SearchEngineType searchEngineType, @Nullable Competitor competitor, ICompareAgainst iCompareAgainst) {
        int n2 = e;
        for (Keyword keyword : this.d) {
            if (this.a(keyword, searchEngineType, competitor, iCompareAgainst)) {
                return true;
            }
            if (n2 == 0) continue;
        }
        return false;
    }

    private boolean a(Keyword keyword, SearchEngineType searchEngineType, @Nullable Competitor competitor, ICompareAgainst iCompareAgainst) {
        KeywordPositionsList keywordPositionsList;
        KeywordPositionsList keywordPositionsList2 = keywordPositionsList = competitor == null ? keyword.getKeywordPositionsList(searchEngineType) : keyword.getCompetitorKeywordPositionsList(competitor, searchEngineType);
        if (keywordPositionsList == null) {
            return false;
        }
        KeywordPosition keywordPosition = keywordPositionsList.getPosition(iCompareAgainst);
        return keywordPosition != null;
    }

    @Override
    public Date getReportCreationDate() {
        return new Date();
    }

    @Override
    public CompareAgainst getCompareAgainst() {
        return this.a.getReportCompareAgainst();
    }

    @Override
    public ValueDifference getVisibilityValueDifference() {
        return this.getVisibilityValueDifference(this.getSearchEngines(), null);
    }

    @Override
    public ValueDifference getVisibilityValueDifference(Competitor competitor) {
        return this.getVisibilityValueDifference(this.getSearchEngines(), competitor);
    }

    @Override
    public ValueDifference getVisibilityValueDifference(SearchEngineType searchEngineType, @Nullable Competitor competitor) {
        return this.getVisibilityValueDifference(Collections.singletonList(searchEngineType), competitor);
    }

    public ValueDifference getVisibilityValueDifference(List<SearchEngineType> list, @Nullable Competitor competitor) {
        int n2 = -1;
        if (this.a(list, competitor, ICompareAgainst.CURRENT_MEASUREMENT)) {
            n2 = this.b(list, competitor, ICompareAgainst.CURRENT_MEASUREMENT);
        }
        int n3 = Integer.MIN_VALUE;
        if (this.a(list, competitor, (ICompareAgainst)this.getCompareAgainst())) {
            n3 = n2 - this.b(list, competitor, this.getCompareAgainst());
        }
        return new ValueDifference(n2, n3);
    }

    private int b(List<SearchEngineType> list, @Nullable Competitor competitor, ICompareAgainst iCompareAgainst) {
        int n2 = competitor == null ? KeywordsList.getVisibilityScore(iCompareAgainst, this.d, list) : KeywordsList.getVisibilityScoreComp(iCompareAgainst, this.d, list, competitor);
        return (int)KeywordsUtil.getVisibility(n2, this.getKeywordsCount(), list.size());
    }

    @Override
    public double getVisibilityPercent(ValueDifference valueDifference) {
        return valueDifference.getValue();
    }

    @Override
    public boolean hasCheckedExpectedVisits() {
        int n2 = e;
        for (Keyword keyword : this.d) {
            long l2 = keyword.getKEI().getSearchNum();
            if (l2 != -2L) {
                return true;
            }
            if (n2 == 0) continue;
        }
        return false;
    }

    @Override
    public long getExpectedVisits() {
        int n2 = e;
        long l2 = 0L;
        for (Keyword keyword : this.d) {
            KEI kEI = keyword.getKEI();
            long l3 = kEI.getSearchNum();
            if (l3 > 0L) {
                l2 += kEI.getKeywordCollectorType().getEstimatedVisits(l3, this.a.getProjectKeywordCollectorSettings().getGoogleAdwordsCountries());
            }
            if (n2 == 0) continue;
        }
        return l2;
    }

    @Override
    public double getExpectedVisitsPercent(long l2) {
        return KeywordsWidgetProjectService.a(l2);
    }

    @Override
    @Nullable
    public Integer getTotalVisits() {
        return this.getTotalVisits(GraphPeriod.ONE_MONTH);
    }

    @Override
    public Integer getTotalVisits(GraphPeriod graphPeriod) {
        Date date = DateUtil.minusDays((int)1);
        Date date2 = graphPeriod != GraphPeriod.ALL_TIME ? graphPeriod.getDate() : this.a.getEntranceDate();
        return this.a(date2, date);
    }

    private Integer a(Date date, Date date2) {
        int n2 = e;
        Map<Date, Number> map = this.b(date, date2);
        if (map.isEmpty()) {
            return null;
        }
        int n3 = 0;
        for (Map.Entry<Date, Number> entry : map.entrySet()) {
            n3 += entry.getValue().intValue();
            if (n2 == 0) continue;
        }
        return n3;
    }

    private Map<Date, Number> b(Date date, Date date2) {
        int n2 = e;
        LinkedHashMap<Date, Number> linkedHashMap = new LinkedHashMap<Date, Number>();
        XYDataset<Number> xYDataset = this.n();
        for (Map.Entry entry : xYDataset.entrySet()) {
            Date date3 = (Date)entry.getKey();
            if (date3.after(date) && date3.before(date2)) {
                linkedHashMap.put((Date)entry.getKey(), (Number)entry.getValue());
            }
            if (n2 == 0) continue;
        }
        return linkedHashMap;
    }

    @Override
    public double getTotalVisitsPercent(long l2) {
        return KeywordsWidgetProjectService.a(l2);
    }

    private static double a(long l2) {
        int n2 = e;
        if (l2 == 0L) {
            return 0.0;
        }
        if (l2 >= 1L && l2 < 100L) {
            return 5.0;
        }
        if (l2 > 1000000L) {
            return 100.0;
        }
        double[][] dArrayArray = new double[][]{{100.0, 5000.0, 0.05, 0.3}, {5000.0, 50000.0, 0.3, 0.5}, {50000.0, 100000.0, 0.5, 0.7}, {100000.0, 1000000.0, 0.7, 1.0}};
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0};
        for (double[] dArray2 : dArrayArray) {
            if (!((double)l2 >= dArray2[0]) || !((double)l2 <= dArray2[1])) continue;
            dArray = dArray2;
            if (n2 == 0) continue;
        }
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        double d5 = dArray[3];
        return (d4 + ((double)l2 - d2) * (d5 - d4) / (d3 - d2)) * 100.0;
    }

    @Override
    public double getDomainStrength() {
        PopularityHistoryMap popularityHistoryMap = this.a.getPopularityHistoryMap();
        return DomainStrengthUtil.getStrength((IPopularityMap)popularityHistoryMap);
    }

    @Override
    public double getDomainStrength(Competitor competitor) {
        PopularityMap popularityMap = competitor.getPopularityMap();
        return DomainStrengthUtil.getStrength((IPopularityMap)popularityMap);
    }

    @Override
    public double getDomainStrengthPercent(double d2) {
        return d2 == -1.0 ? 0.0 : d2 * 10.0;
    }

    @Override
    public int getPositionsLimit() {
        return this.c.getKeywordsSearchLimits().getPositionsLimit();
    }

    @Override
    public ValueDifference getKeywordsInTopValueDifference(SearchEngineType searchEngineType, @Nullable Competitor competitor, int n2) {
        int n3 = -1;
        if (this.a(searchEngineType, competitor, ICompareAgainst.CURRENT_MEASUREMENT)) {
            n3 = this.a(searchEngineType, competitor, ICompareAgainst.CURRENT_MEASUREMENT, n2);
        }
        int n4 = Integer.MIN_VALUE;
        if (this.a(searchEngineType, competitor, (ICompareAgainst)this.getCompareAgainst())) {
            n4 = n3 - this.a(searchEngineType, competitor, (ICompareAgainst)this.getCompareAgainst(), n2);
        }
        return new ValueDifference(n3, n4);
    }

    private int a(SearchEngineType searchEngineType, @Nullable Competitor competitor, ICompareAgainst iCompareAgainst, int n2) {
        return KeywordsList.getInTop(iCompareAgainst, this.d, Collections.singletonList(searchEngineType), competitor, n2);
    }

    @Override
    public ValueDifference getKeywordsNotInTopValueDifference(SearchEngineType searchEngineType, @Nullable Competitor competitor, int n2) {
        int n3 = -1;
        if (this.a(searchEngineType, competitor, ICompareAgainst.CURRENT_MEASUREMENT)) {
            n3 = this.b(searchEngineType, competitor, ICompareAgainst.CURRENT_MEASUREMENT, n2);
        }
        int n4 = Integer.MIN_VALUE;
        if (this.a(searchEngineType, competitor, (ICompareAgainst)this.getCompareAgainst())) {
            n4 = n3 - this.b(searchEngineType, competitor, this.getCompareAgainst(), n2);
        }
        return new ValueDifference(n3, n4);
    }

    private int b(SearchEngineType searchEngineType, @Nullable Competitor competitor, ICompareAgainst iCompareAgainst, int n2) {
        return KeywordsList.getNonInTop(iCompareAgainst, this.d, Collections.singletonList(searchEngineType), competitor, n2);
    }

    @Override
    public UniversalResult getKeywordsInUniversalValueDifference(SearchEngineType searchEngineType, @Nullable Competitor competitor, UniversalSearchType universalSearchType) {
        int n2 = -1;
        int n3 = -1;
        int n4 = Integer.MIN_VALUE;
        if (MajorSearchEngineType.isUniversalResultSupport((MajorSearchEngineType.MajorType)searchEngineType.getMajorType().getMajorType())) {
            boolean bl = this.c.isUseUniversalSearch();
            if (bl && this.a(searchEngineType, competitor, ICompareAgainst.CURRENT_MEASUREMENT)) {
                n2 = this.a(searchEngineType, competitor, universalSearchType);
                n3 = this.a(searchEngineType, competitor, ICompareAgainst.CURRENT_MEASUREMENT, universalSearchType);
            }
            if (bl && this.a(searchEngineType, competitor, (ICompareAgainst)this.getCompareAgainst())) {
                n4 = n3 - this.a(searchEngineType, competitor, (ICompareAgainst)this.getCompareAgainst(), universalSearchType);
            }
        }
        return new UniversalResult(n2, n3, n4);
    }

    private int a(SearchEngineType searchEngineType, @Nullable Competitor competitor, ICompareAgainst iCompareAgainst, UniversalSearchType universalSearchType) {
        int n2 = e;
        int n3 = 0;
        for (Keyword keyword : this.d) {
            KeywordPosition keywordPosition;
            KeywordPositionsList keywordPositionsList;
            KeywordPositionsList keywordPositionsList2 = keywordPositionsList = competitor == null ? keyword.getKeywordPositionsList(searchEngineType) : keyword.getCompetitorKeywordPositionsList(competitor, searchEngineType);
            if (keywordPositionsList == null && n2 == 0 || (keywordPosition = keywordPositionsList.getPosition(iCompareAgainst)) == null && n2 == 0) continue;
            if (this.a(keywordPosition, universalSearchType)) {
                ++n3;
            }
            if (n2 == 0) continue;
        }
        return n3;
    }

    private boolean a(KeywordPosition keywordPosition, UniversalSearchType universalSearchType) {
        int n2 = e;
        boolean bl = this.c.isTrackMultiplePositions();
        List<IKeywordPosition> list = keywordPosition.getPositions();
        for (int i2 = 0; i2 < (bl ? list.size() : 1); ++i2) {
            IKeywordPosition iKeywordPosition = list.get(i2);
            if (iKeywordPosition.getUniversalSearchType() != universalSearchType) continue;
            return true;
        }
        return false;
    }

    private int a(SearchEngineType searchEngineType, @Nullable Competitor competitor, UniversalSearchType universalSearchType) {
        int n2 = e;
        int n3 = 0;
        for (Keyword keyword : this.d) {
            UniversalSearchTypesList universalSearchTypesList;
            KeywordPosition keywordPosition;
            KeywordPositionsList keywordPositionsList;
            KeywordPositionsList keywordPositionsList2 = keywordPositionsList = competitor == null ? keyword.getKeywordPositionsList(searchEngineType) : keyword.getCompetitorKeywordPositionsList(competitor, searchEngineType);
            if (keywordPositionsList == null && n2 == 0 || (keywordPosition = keywordPositionsList.getPosition()) == null && n2 == 0) continue;
            if (universalSearchType == keywordPosition.getUniversalSearchType()) {
                ++n3;
                if (n2 == 0) continue;
            }
            if ((universalSearchTypesList = keywordPosition.getUniversalSearchTypesList()) == null && n2 == 0) continue;
            if (universalSearchTypesList.contains((Object)universalSearchType)) {
                ++n3;
            }
            if (n2 == 0) continue;
        }
        return n3;
    }

    public int getKeywordsMovedUp(SearchEngineType searchEngineType) {
        return this.getKeywordsMovedUp(searchEngineType, (Competitor)null);
    }

    @Override
    public int getKeywordsMovedUp(SearchEngineType searchEngineType, @Nullable Competitor competitor) {
        return this.a(searchEngineType, competitor, (ICompareAgainst)this.getCompareAgainst(), true);
    }

    public int getKeywordsMovedDown(SearchEngineType searchEngineType) {
        return this.getKeywordsMovedDown(searchEngineType, (Competitor)null);
    }

    @Override
    public int getKeywordsMovedDown(SearchEngineType searchEngineType, @Nullable Competitor competitor) {
        return this.a(searchEngineType, competitor, (ICompareAgainst)this.getCompareAgainst(), false);
    }

    private int a(SearchEngineType searchEngineType, @Nullable Competitor competitor, ICompareAgainst iCompareAgainst, boolean bl) {
        int n2 = e;
        if (!this.a(searchEngineType, competitor, (ICompareAgainst)this.getCompareAgainst())) {
            return -1;
        }
        int n3 = 0;
        for (Keyword keyword : this.d) {
            KeywordPositionsList keywordPositionsList;
            KeywordPositionsList keywordPositionsList2 = keywordPositionsList = competitor == null ? keyword.getKeywordPositionsList(searchEngineType) : keyword.getCompetitorKeywordPositionsList(competitor, searchEngineType);
            if (keywordPositionsList == null && n2 == 0) continue;
            if (keywordPositionsList.getMovedUpOrDown(iCompareAgainst, bl)) {
                ++n3;
            }
            if (n2 == 0) continue;
        }
        return n3;
    }

    @Override
    public double getKeywordsMovedPercent(int n2) {
        return MathUtil.getPercent100((double)this.d.size(), (double)n2);
    }

    @Override
    public Collection<UnicodeURL> getPages() {
        int n2 = e;
        LinkedHashSet<UnicodeURL> linkedHashSet = new LinkedHashSet<UnicodeURL>();
        for (Keyword keyword : this.d) {
            Set<UnicodeURL> set = KeywordsUtil.getKeywordFoundUrls(keyword, this.getSearchEngines());
            linkedHashSet.addAll(set);
            if (n2 == 0) continue;
        }
        ArrayList arrayList = new ArrayList(linkedHashSet);
        Collections.sort(arrayList, this::a);
        return arrayList;
    }

    @Override
    @Nullable
    public Integer getVisits(UnicodeURL unicodeURL) {
        PageVisitsList pageVisitsList = this.a.getPageSessions();
        PageVisits pageVisits = pageVisitsList.getPageVisit(unicodeURL);
        if (pageVisits != null) {
            return pageVisits.getVisitNumber();
        }
        return null;
    }

    @Override
    public List<IKeywordInfo> getKeywords(UnicodeURL unicodeURL) {
        int n2 = e;
        ArrayList<IKeywordInfo> arrayList = new ArrayList<IKeywordInfo>();
        boolean bl = this.c.isTrackMultiplePositions();
        for (Keyword keyword : this.d) {
            Set<UnicodeURL> set = KeywordsUtil.getKeywordFoundUrls(keyword, this.getSearchEngines());
            if (set.contains(unicodeURL)) {
                arrayList.add(new KeywordInfo(keyword, this.getSearchEngines(), this.a.getProjectKeywordCollectorSettings().getGoogleAdwordsCountries(), bl));
            }
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    @Override
    public List<IKeywordGroup> getKeywordGroups() {
        int n2 = e;
        ArrayList<IKeywordGroup> arrayList = new ArrayList<IKeywordGroup>();
        for (Keyword keyword : this.d) {
            if (!arrayList.contains(keyword.getGroup())) {
                arrayList.add(keyword.getGroup());
            }
            if (n2 == 0) continue;
        }
        Collections.sort(arrayList, new h(this, null));
        return arrayList;
    }

    @Override
    @Nullable
    public Long getSearchVolume(@Nullable IKeywordGroup iKeywordGroup) {
        int n2 = e;
        Long l2 = null;
        for (IKeywordInfo iKeywordInfo : this.getKeywords(iKeywordGroup)) {
            SearchVolumeRange searchVolumeRange = iKeywordInfo.getSearchVolumeRange();
            long l3 = searchVolumeRange.getSearchVolume();
            if (l3 < 0L && n2 == 0) continue;
            if (l2 == null) {
                l2 = 0L;
            }
            l2 = l2 + l3;
            if (n2 == 0) continue;
        }
        return l2;
    }

    @Override
    public List<? extends IKeywordInfo> getKeywords(@Nullable IKeywordGroup iKeywordGroup) {
        return this.d.stream().filter(arg_0 -> KeywordsWidgetProjectService.a(iKeywordGroup, arg_0)).map(new i(this, null)::apply).collect(Collectors.toList());
    }

    @Override
    public List<ILandingPage> getLandingPages() {
        int n2 = e;
        ArrayList<ILandingPage> arrayList = new ArrayList<ILandingPage>();
        for (Keyword keyword : this.d) {
            if (!Util.contains(arrayList, (Object)keyword.getLandingPage(), (Comparator)new j(null))) {
                arrayList.add(keyword.getLandingPage());
            }
            if (n2 == 0) continue;
        }
        Collections.sort(arrayList, new g(this, null));
        return arrayList;
    }

    @Override
    @Nullable
    public Long getExpectedVisits(ILandingPage iLandingPage) {
        int n2 = e;
        Long l2 = null;
        for (IKeywordInfo iKeywordInfo : this.getKeywords(iLandingPage)) {
            long l3 = iKeywordInfo.getExpectedVisits();
            if (l3 < 0L && n2 == 0) continue;
            if (l2 == null) {
                l2 = 0L;
            }
            l2 = l2 + l3;
            if (n2 == 0) continue;
        }
        return l2;
    }

    @Override
    public List<? extends IKeywordInfo> getKeywords(@Nullable ILandingPage iLandingPage) {
        return this.d.stream().filter(arg_0 -> KeywordsWidgetProjectService.a(iLandingPage, arg_0)).map(new i(this, null)::apply).collect(Collectors.toList());
    }

    @Override
    public XYChartData<Integer> getTotalVisibilityChartData(GraphPeriod graphPeriod) {
        List<SearchEngineType> list = this.getSearchEngines();
        XYDataset<Integer> xYDataset = KeywordsList.getVisibilityPercentMap(this.d, list);
        xYDataset.setColor(this.a.getProjectColor());
        return new XYChartData.Builder().addSeriesDataset(xYDataset).setStartDatePeriod(graphPeriod != GraphPeriod.ALL_TIME ? graphPeriod.getDate() : this.a.getEntranceDate()).build();
    }

    @Override
    public XYChartData<Integer> getBySearchEngineVisibilityChartData(GraphPeriod graphPeriod) {
        int n2 = e;
        List<SearchEngineType> list = this.getSearchEngines();
        ArrayList<XYDataset<Integer>> arrayList = new ArrayList<XYDataset<Integer>>();
        for (SearchEngineType searchEngineType : list) {
            XYDataset<Integer> xYDataset = KeywordsList.getVisibilityPercentMap(this.d, Collections.singletonList(searchEngineType));
            xYDataset.setColor(this.b.getColor((Object)searchEngineType));
            arrayList.add(xYDataset);
            if (n2 == 0) continue;
        }
        XYChartData xYChartData = new XYChartData.Builder().setSeriesDatasets(arrayList).setStartDatePeriod(graphPeriod != GraphPeriod.ALL_TIME ? graphPeriod.getDate() : this.a.getEntranceDate()).build();
        if (RankTrackerStringKey.b) {
            e = ++n2;
        }
        return xYChartData;
    }

    @Override
    public XYChartData<Integer> getProjectAndCompetitorsVisibilityChartData(GraphPeriod graphPeriod) {
        int n2 = e;
        List<SearchEngineType> list = this.getSearchEngines();
        List<Competitor> list2 = this.getCompetitors();
        ArrayList<XYDataset<Integer>> arrayList = new ArrayList<XYDataset<Integer>>();
        XYDataset<Integer> xYDataset = KeywordsList.getVisibilityPercentMap(this.d, list);
        xYDataset.setColor(this.a.getProjectColor());
        arrayList.add(xYDataset);
        for (Competitor competitor : list2) {
            XYDataset<Integer> xYDataset2 = KeywordsList.getVisibilityPercentMap(this.d, list, competitor);
            xYDataset2.setColor(competitor.getKeywordColor());
            arrayList.add(xYDataset2);
            if (n2 == 0) continue;
            RankTrackerStringKey.b = !RankTrackerStringKey.b;
            break;
        }
        return new XYChartData.Builder().setSeriesDatasets(arrayList).setStartDatePeriod(graphPeriod != GraphPeriod.ALL_TIME ? graphPeriod.getDate() : this.a.getEntranceDate()).build();
    }

    @Override
    public XYChartData<Number> getVisitsChartData(GraphPeriod graphPeriod) {
        XYDataset<Number> xYDataset = this.n();
        return new XYChartData.Builder().addSeriesDataset(xYDataset).setStartDatePeriod(graphPeriod != GraphPeriod.ALL_TIME ? graphPeriod.getDate() : this.a.getEntranceDate()).build();
    }

    private XYDataset<Number> n() {
        int n2 = e;
        XYDataset xYDataset = new XYDataset(this.a.getProjectColor());
        Date date = this.a.getLastSiteSessionsCheckDate();
        if (date == null) {
            return xYDataset;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, -1);
        SessionsList sessionsList = this.a.getTotalSiteSessions();
        for (int i2 = sessionsList.size() - 1; i2 >= 0; --i2) {
            Date date2 = DateUtil.getStartDay((Date)calendar.getTime());
            xYDataset.put((Object)date2, sessionsList.get(i2));
            calendar.add(6, -1);
            if (n2 == 0) continue;
        }
        return xYDataset;
    }

    private static boolean a(@Nullable ILandingPage iLandingPage, Keyword keyword) {
        if (keyword.getLandingPage() == null && iLandingPage == null) {
            return true;
        }
        if (keyword.getLandingPage() != null && iLandingPage != null) {
            return keyword.getLandingPage().getUrl().equals((Object)iLandingPage.getUrl());
        }
        return false;
    }

    private static boolean a(@Nullable IKeywordGroup iKeywordGroup, Keyword keyword) {
        return keyword.getGroup() == iKeywordGroup;
    }

    private int a(UnicodeURL unicodeURL, UnicodeURL unicodeURL2) {
        return Util.compare((Object)this.getVisits(unicodeURL2), (Object)this.getVisits(unicodeURL));
    }

    private static int a(IKeywordInfo iKeywordInfo, IKeywordInfo iKeywordInfo2) {
        return iKeywordInfo.getQuery().compareToIgnoreCase(iKeywordInfo2.getQuery());
    }

    private IKeywordInfo a(boolean bl, Keyword keyword) {
        return new KeywordInfo(keyword, this.getSearchEngines(), this.a.getProjectKeywordCollectorSettings().getGoogleAdwordsCountries(), bl);
    }

    static RankTrackerProject a(KeywordsWidgetProjectService keywordsWidgetProjectService) {
        return keywordsWidgetProjectService.a;
    }

    static KeywordTrackingSettings b(KeywordsWidgetProjectService keywordsWidgetProjectService) {
        return keywordsWidgetProjectService.c;
    }
}

