/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.spyglass.modules.comparision.data;

import com.agilemind.spyglass.data.AnalyzeRecord;
import com.agilemind.spyglass.data.SpyGlassProject;
import com.agilemind.spyglass.modules.comparision.data.CompareFactor;
import com.agilemind.spyglass.modules.comparision.data.CompareFactorType;
import com.agilemind.spyglass.modules.comparision.data.CompareResult;
import com.agilemind.spyglass.modules.comparision.data.ICompareFactorsFactory;
import com.agilemind.spyglass.modules.comparision.data.factors.project.AnchorDiversityProjectCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.project.AnchorUrlsProjectCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.project.AnchorsProjectCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.project.BacklinkDomainsCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.project.BacklinksProjectCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.project.CBlocksProjectCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.project.DofollowBacklinksProjectCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.project.DomainAgeProjectCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.project.DomainAlexaRankCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.project.DomainGooglePRAuthorityCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.project.DomainStrengthCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.project.HomepageLinkingDomainsProjectCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.project.IPProjectCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.project.KeywordsProjectCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.project.TextLinksProjectCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.project.TopCountryProjectCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.project.TopTLDProjectCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.result.DomainStrengthCompareResult;
import com.agilemind.spyglass.util.BacklinkAnalyzeUtil;
import java.util.List;

public class ProjectCompareFactorsFactory
implements ICompareFactorsFactory {
    private final SpyGlassProject a;
    private final List<AnalyzeRecord> b;
    private static final String c;

    public ProjectCompareFactorsFactory(SpyGlassProject spyGlassProject) {
        this.a = spyGlassProject;
        this.b = BacklinkAnalyzeUtil.getAcceptedBacklinks(spyGlassProject);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CompareFactor getCompareFactor(CompareFactorType compareFactorType) {
        CompareFactor<DomainStrengthCompareResult> compareFactor;
        boolean bl = CompareResult.d;
        switch (compareFactorType) {
            case DOMAIN_STRENGTH: {
                compareFactor = new DomainStrengthCompareFactor(this.a);
                if (!bl) break;
            }
            case DOMAIN_GOOGLE_PR_AUTHORITY: {
                compareFactor = new DomainGooglePRAuthorityCompareFactor(this.a);
                if (!bl) break;
            }
            case DOMAIN_ALEXA_RANK: {
                compareFactor = new DomainAlexaRankCompareFactor(this.a);
                if (!bl) break;
            }
            case DOMAIN_AGE: {
                compareFactor = new DomainAgeProjectCompareFactor(this.a);
                if (!bl) break;
            }
            case BACKLINKS: {
                compareFactor = new BacklinksProjectCompareFactor(this.b);
                if (!bl) break;
            }
            case BACKLINK_DOMAINS: {
                compareFactor = new BacklinkDomainsCompareFactor(this.b);
                if (!bl) break;
            }
            case IPS: {
                compareFactor = new IPProjectCompareFactor(this.b);
                if (!bl) break;
            }
            case C_BLOCKS: {
                compareFactor = new CBlocksProjectCompareFactor(this.b);
                if (!bl) break;
            }
            case DOFOLLOW_BACKLINKS: {
                compareFactor = new DofollowBacklinksProjectCompareFactor(this.b);
                if (!bl) break;
            }
            case HOMEPAGE_LINKING_DOMAINS: {
                compareFactor = new HomepageLinkingDomainsProjectCompareFactor(this.b);
                if (!bl) break;
            }
            case TOP_TLD: {
                compareFactor = new TopTLDProjectCompareFactor(this.b);
                if (!bl) break;
            }
            case TOP_COUNTRY: {
                compareFactor = new TopCountryProjectCompareFactor(this.b);
                if (!bl) break;
            }
            case TEXT_LINKS: {
                compareFactor = new TextLinksProjectCompareFactor(this.b);
                if (!bl) break;
            }
            case ANCHORS: {
                compareFactor = new AnchorsProjectCompareFactor(this.b);
                if (!bl) break;
            }
            case ANCHOR_DIVERSITY: {
                compareFactor = new AnchorDiversityProjectCompareFactor(this.b);
                if (!bl) break;
            }
            case KEYWORDS: {
                compareFactor = new KeywordsProjectCompareFactor(this.b);
                if (!bl) break;
            }
            case ANCHOR_URLS: {
                compareFactor = new AnchorUrlsProjectCompareFactor(this.b);
                if (!bl) break;
            }
            default: {
                throw new IllegalArgumentException(c + (Object)((Object)compareFactorType));
            }
        }
        return compareFactor;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "\u0007Z\u0006@\u0001%ZMm\u0001?D\f\\\u000b\u0014U\u000eZ\u0001 `\u0014^\u000br".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 82;
                            break;
                        }
                        case 1: {
                            n7 = 52;
                            break;
                        }
                        case 2: {
                            n7 = 109;
                            break;
                        }
                        case 3: {
                            n7 = 46;
                            break;
                        }
                        default: {
                            n7 = 110;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        c = new String(cArray).intern();
    }
}

