/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.spyglass.util;

import com.agilemind.commons.application.data.ScanResult;
import com.agilemind.commons.application.modules.io.searchengine.data.PopularityMap;
import com.agilemind.commons.application.modules.io.searchengine.data.SearchEngineFactor;
import com.agilemind.commons.application.modules.linkinfo.data.AnchorType;
import com.agilemind.commons.application.modules.linkinfo.data.LinkInfo;
import com.agilemind.commons.application.modules.widget.util.RecordAnalyzeUtil;
import com.agilemind.commons.application.modules.widget.util.to.AnchorAltTextResult;
import com.agilemind.commons.application.modules.widget.util.to.AnchorUrlResult;
import com.agilemind.commons.application.modules.widget.util.to.KeywordsResult;
import com.agilemind.commons.application.modules.widget.util.to.analyze.CountryResult;
import com.agilemind.commons.application.modules.widget.util.to.analyze.DofollowNofollowDistribution;
import com.agilemind.commons.application.modules.widget.util.to.analyze.HomepageLinksDistribution;
import com.agilemind.commons.application.modules.widget.util.to.analyze.PRDistribution;
import com.agilemind.commons.application.modules.widget.util.to.analyze.TLDResult;
import com.agilemind.commons.application.modules.widget.util.to.analyze.TextImageDistribution;
import com.agilemind.commons.io.searchengine.analyzers.SearchEngineFactorsList;
import com.agilemind.commons.io.searchengine.analyzers.data.FactorType;
import com.agilemind.commons.io.searchengine.analyzers.data.SearchEngineFactorType;
import com.agilemind.commons.io.searchengine.validator.ILinkInfo;
import com.agilemind.commons.io.searchengine.validator.scanstatus.ScanStatus;
import com.agilemind.commons.io.utils.ip.data.IP;
import com.agilemind.commons.localization.stringkey.Country;
import com.agilemind.commons.util.DateUtil;
import com.agilemind.commons.util.MathUtil;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.UnicodeURLUtil;
import com.agilemind.spyglass.data.AnalyzeRecord;
import com.agilemind.spyglass.data.SpyGlassProject;
import com.agilemind.spyglass.util.CollectBackLinksCompositeOperation;
import com.agilemind.spyglass.util.q;
import com.agilemind.spyglass.util.r;
import com.agilemind.spyglass.util.s;
import com.agilemind.spyglass.util.t;
import com.agilemind.spyglass.util.v;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class BacklinkAnalyzeUtil {
    public static final int NO_DATA = -1;
    private static final Pattern a;
    private static final String[] b;

    public static int getUniqueDomainsCount(List<AnalyzeRecord> list) {
        boolean bl = CollectBackLinksCompositeOperation.c;
        ArrayList<UnicodeURL> arrayList = new ArrayList<UnicodeURL>();
        for (AnalyzeRecord analyzeRecord : list) {
            arrayList.add(analyzeRecord.getPage());
            if (!bl) continue;
        }
        return BacklinkAnalyzeUtil.getUniqueHomepagesCount(arrayList);
    }

    public static int getDofollowDomainsCount(List<AnalyzeRecord> list) {
        boolean bl = CollectBackLinksCompositeOperation.c;
        ArrayList<UnicodeURL> arrayList = new ArrayList<UnicodeURL>();
        for (AnalyzeRecord analyzeRecord : list) {
            block5: {
                ScanResult scanResult = analyzeRecord.getScanResult();
                ScanStatus scanStatus = scanResult.getScanStatus();
                if (scanStatus == ScanStatus.SCAN_STATUS_UNKNOWN || !scanStatus.isOkStatus()) break block5;
                arrayList.add(analyzeRecord.getPage());
            }
            if (!bl) continue;
        }
        return BacklinkAnalyzeUtil.getUniqueHomepagesCount(arrayList);
    }

    public static int getHomepageLinkingDomainsCount(List<AnalyzeRecord> list) {
        boolean bl = CollectBackLinksCompositeOperation.c;
        ArrayList<UnicodeURL> arrayList = new ArrayList<UnicodeURL>();
        for (AnalyzeRecord analyzeRecord : list) {
            UnicodeURL unicodeURL = analyzeRecord.getPage();
            boolean bl2 = UnicodeURLUtil.isHomePageIncludeIndex((UnicodeURL)unicodeURL);
            if (bl2) {
                arrayList.add(unicodeURL);
            }
            if (!bl) continue;
        }
        return BacklinkAnalyzeUtil.getUniqueHomepagesCount(arrayList);
    }

    public static int getToHomepageAnchorCount(List<AnalyzeRecord> list, boolean bl) {
        boolean bl2 = CollectBackLinksCompositeOperation.c;
        ArrayList<UnicodeURL> arrayList = new ArrayList<UnicodeURL>();
        for (AnalyzeRecord analyzeRecord : list) {
            block5: {
                ILinkInfo iLinkInfo = analyzeRecord.getLinkInfo();
                if (iLinkInfo == null || bl == UnicodeURLUtil.isHomePageIncludeIndex((UnicodeURL)iLinkInfo.getDomain())) break block5;
                arrayList.add(iLinkInfo.getDomain());
            }
            if (!bl2) continue;
        }
        return arrayList.size();
    }

    public static int getUniqueIPsCount(List<AnalyzeRecord> list) {
        boolean bl = CollectBackLinksCompositeOperation.c;
        if (list.isEmpty()) {
            return 0;
        }
        boolean bl2 = false;
        HashSet<IP> hashSet = new HashSet<IP>();
        for (AnalyzeRecord analyzeRecord : list) {
            SearchEngineFactor searchEngineFactor = analyzeRecord.getRankingFactorsMap().getFactor((FactorType)SearchEngineFactorsList.DOMAIN_IP_FACTOR_TYPE);
            if (searchEngineFactor == null && !bl) continue;
            bl2 = true;
            IP iP = (IP)searchEngineFactor.getFactorValue();
            if (iP == null && !bl) continue;
            hashSet.add(iP);
            if (!bl) continue;
        }
        int n2 = bl2 ? hashSet.size() : -1;
        return n2;
    }

    public static int getUniqueCBlocksCount(List<AnalyzeRecord> list) {
        boolean bl = CollectBackLinksCompositeOperation.c;
        if (list.isEmpty()) {
            return 0;
        }
        boolean bl2 = false;
        HashSet<String> hashSet = new HashSet<String>();
        for (AnalyzeRecord analyzeRecord : list) {
            SearchEngineFactor searchEngineFactor = analyzeRecord.getRankingFactorsMap().getFactor((FactorType)SearchEngineFactorsList.DOMAIN_IP_FACTOR_TYPE);
            if (searchEngineFactor == null && !bl) continue;
            bl2 = true;
            IP iP = (IP)searchEngineFactor.getFactorValue();
            if (iP == null && !bl) continue;
            StringBuilder stringBuilder = new StringBuilder();
            int[] nArray = iP.getDigits();
            for (int i2 = 0; i2 < nArray.length - 1; ++i2) {
                stringBuilder.append(nArray[i2]);
                if (!bl) continue;
            }
            hashSet.add(stringBuilder.toString());
            if (!bl) continue;
        }
        int n2 = bl2 ? hashSet.size() : -1;
        return n2;
    }

    public static int getUniqueAnchorsCount(List<AnalyzeRecord> list) {
        boolean bl = CollectBackLinksCompositeOperation.c;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (AnalyzeRecord analyzeRecord : list) {
            block12: {
                String string;
                block11: {
                    ScanResult scanResult = analyzeRecord.getScanResult();
                    if (scanResult == null && !bl) continue;
                    LinkInfo linkInfo = scanResult.getLinkInfo();
                    if (linkInfo == null && !bl) continue;
                    string = BacklinkAnalyzeUtil.a(linkInfo);
                    AnchorType anchorType = linkInfo.getAnchorType();
                    if (anchorType != AnchorType.TEXT_LINK || linkInfo.getBanner() != null) break block11;
                    hashSet.add(string);
                    if (!bl) break block12;
                }
                hashSet2.add(string);
            }
            if (!bl) continue;
        }
        return hashSet.size() + hashSet2.size();
    }

    public static int getUniqueKeywordsCount(List<AnalyzeRecord> list) {
        boolean bl = CollectBackLinksCompositeOperation.c;
        HashSet<String> hashSet = new HashSet<String>();
        for (AnalyzeRecord analyzeRecord : list) {
            String string = analyzeRecord.getAnchorText();
            if (string != null) {
                Collection<String> collection = BacklinkAnalyzeUtil.getUniqueKeywords(string);
                hashSet.addAll(collection);
            }
            if (!bl) continue;
        }
        return hashSet.size();
    }

    public static int getUniqueAnchorUrlsCount(List<AnalyzeRecord> list) {
        boolean bl = CollectBackLinksCompositeOperation.c;
        HashSet<String> hashSet = new HashSet<String>();
        for (AnalyzeRecord analyzeRecord : list) {
            UnicodeURL unicodeURL = analyzeRecord.getAnchorUrl();
            if (unicodeURL != null) {
                hashSet.add(BacklinkAnalyzeUtil.a(unicodeURL).toLowerCase());
            }
            if (!bl) continue;
        }
        return hashSet.size();
    }

    public static List<CountryResult> getCountryDistributions(List<AnalyzeRecord> list) {
        boolean bl = CollectBackLinksCompositeOperation.c;
        ArrayList<CountryResult> arrayList = new ArrayList<CountryResult>();
        Map<Country, List<UnicodeURL>> map = BacklinkAnalyzeUtil.a(list);
        int n2 = BacklinkAnalyzeUtil.getUniqueDomainsCount(list);
        for (Map.Entry<Country, List<UnicodeURL>> entry : map.entrySet()) {
            int n3 = BacklinkAnalyzeUtil.getUniqueHomepagesCount((Collection<UnicodeURL>)entry.getValue());
            double d2 = MathUtil.getPercent((double)n2, (double)n3);
            arrayList.add(new CountryResult(entry.getKey(), n3, d2));
            if (!bl) continue;
        }
        Collections.sort(arrayList, BacklinkAnalyzeUtil::a);
        return arrayList;
    }

    private static Map<Country, List<UnicodeURL>> a(List<AnalyzeRecord> list) {
        boolean bl = CollectBackLinksCompositeOperation.c;
        HashMap<Country, List<UnicodeURL>> hashMap = new HashMap<Country, List<UnicodeURL>>();
        for (AnalyzeRecord analyzeRecord : list) {
            SearchEngineFactor searchEngineFactor = analyzeRecord.getRankingFactorsMap().getFactor((FactorType)SearchEngineFactorsList.DOMAIN_IP_FACTOR_TYPE);
            if (searchEngineFactor == null && !bl) continue;
            IP iP = (IP)searchEngineFactor.getFactorValue();
            if (iP == null && !bl) continue;
            Country country = iP.getCountry();
            if (country.equals((Object)Country.UNKNOWN) && !bl) continue;
            ArrayList<UnicodeURL> arrayList = (ArrayList<UnicodeURL>)hashMap.get(country);
            if (arrayList == null) {
                arrayList = new ArrayList<UnicodeURL>();
                hashMap.put(country, arrayList);
            }
            arrayList.add(analyzeRecord.getPage());
            if (!bl) continue;
        }
        return hashMap;
    }

    public static List<TLDResult> getTLDDistribution(List<AnalyzeRecord> list) {
        boolean bl = CollectBackLinksCompositeOperation.c;
        ArrayList<TLDResult> arrayList = new ArrayList<TLDResult>();
        Map<String, List<UnicodeURL>> map = BacklinkAnalyzeUtil.b(list);
        int n2 = BacklinkAnalyzeUtil.getUniqueDomainsCount(list);
        for (Map.Entry<String, List<UnicodeURL>> entry : map.entrySet()) {
            int n3 = BacklinkAnalyzeUtil.getUniqueHomepagesCount((Collection<UnicodeURL>)entry.getValue());
            double d2 = MathUtil.getPercent100((double)n2, (double)n3);
            if (entry.getKey() != null) {
                arrayList.add(new TLDResult(entry.getKey(), n3, d2));
            }
            if (!bl) continue;
        }
        Collections.sort(arrayList, BacklinkAnalyzeUtil::a);
        return arrayList;
    }

    private static Map<String, List<UnicodeURL>> b(List<AnalyzeRecord> list) {
        boolean bl = CollectBackLinksCompositeOperation.c;
        HashMap<String, List<UnicodeURL>> hashMap = new HashMap<String, List<UnicodeURL>>();
        for (AnalyzeRecord analyzeRecord : list) {
            if (a.matcher(analyzeRecord.getPage().getUnicodeHost()).find() && !bl) continue;
            String string = UnicodeURLUtil.getTld((UnicodeURL)analyzeRecord.getPage());
            if (!StringUtil.isEmpty((String)string)) {
                ArrayList<UnicodeURL> arrayList = (ArrayList<UnicodeURL>)hashMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<UnicodeURL>();
                    hashMap.put(string, arrayList);
                }
                arrayList.add(analyzeRecord.getPage());
            }
            if (!bl) continue;
        }
        return hashMap;
    }

    public static List<AnchorAltTextResult> getPagesTopAnchorTexts(List<AnalyzeRecord> list) {
        return BacklinkAnalyzeUtil.getPagesTopAnchorTexts(list, true);
    }

    public static List<AnchorAltTextResult> getPagesTopAnchorTexts(List<AnalyzeRecord> list, boolean bl) {
        return RecordAnalyzeUtil.getPagesTopAnchorAltTexts(list, AnalyzeRecord::getScanResult, AnalyzeRecord::getPage, (boolean)bl);
    }

    public static List<AnchorAltTextResult> getDomainsTopAnchorTexts(List<AnalyzeRecord> list) {
        return RecordAnalyzeUtil.getDomainsTopAnchorAltTexts(list, AnalyzeRecord::getScanResult, AnalyzeRecord::getPage, (boolean)true);
    }

    public static List<KeywordsResult> getPagesTopKeywords(List<AnalyzeRecord> list) {
        boolean bl = CollectBackLinksCompositeOperation.c;
        ArrayList<KeywordsResult> arrayList = new ArrayList<KeywordsResult>();
        Map<String, List<UnicodeURL>> map = BacklinkAnalyzeUtil.c(list);
        for (Map.Entry<String, List<UnicodeURL>> entry : map.entrySet()) {
            int n2 = entry.getValue().size();
            double d2 = MathUtil.getPercent100((double)list.size(), (double)n2);
            arrayList.add(new KeywordsResult(entry.getKey(), n2, d2));
            if (!bl) continue;
        }
        Collections.sort(arrayList, new v(null));
        return arrayList;
    }

    public static List<KeywordsResult> getDomainsTopKeywords(List<AnalyzeRecord> list) {
        boolean bl = CollectBackLinksCompositeOperation.c;
        ArrayList<KeywordsResult> arrayList = new ArrayList<KeywordsResult>();
        Map<String, List<UnicodeURL>> map = BacklinkAnalyzeUtil.c(list);
        int n2 = BacklinkAnalyzeUtil.getUniqueDomainsCount(list);
        for (Map.Entry<String, List<UnicodeURL>> entry : map.entrySet()) {
            int n3 = BacklinkAnalyzeUtil.getUniqueHomepagesCount((Collection<UnicodeURL>)entry.getValue());
            double d2 = MathUtil.getPercent100((double)n2, (double)n3);
            arrayList.add(new KeywordsResult(entry.getKey(), n3, d2));
            if (!bl) continue;
        }
        Collections.sort(arrayList, new v(null));
        return arrayList;
    }

    private static Map<String, List<UnicodeURL>> c(List<AnalyzeRecord> list) {
        boolean bl = CollectBackLinksCompositeOperation.c;
        HashMap<String, List<UnicodeURL>> hashMap = new HashMap<String, List<UnicodeURL>>();
        for (AnalyzeRecord analyzeRecord : list) {
            String string = analyzeRecord.getAnchorText();
            if (string == null && !bl) continue;
            Collection<String> collection = BacklinkAnalyzeUtil.getUniqueKeywords(string);
            for (String string2 : collection) {
                ArrayList<UnicodeURL> arrayList = (ArrayList<UnicodeURL>)hashMap.get(string2);
                if (arrayList == null) {
                    arrayList = new ArrayList<UnicodeURL>();
                    hashMap.put(string2, arrayList);
                }
                arrayList.add(analyzeRecord.getPage());
                if (!bl) continue;
            }
            if (!bl) continue;
        }
        return hashMap;
    }

    public static List<AnchorUrlResult> getPagesTopAnchorUrls(List<AnalyzeRecord> list) {
        boolean bl = CollectBackLinksCompositeOperation.c;
        ArrayList<AnchorUrlResult> arrayList = new ArrayList<AnchorUrlResult>();
        Map<UnicodeURL, List<UnicodeURL>> map = BacklinkAnalyzeUtil.d(list);
        for (Map.Entry<UnicodeURL, List<UnicodeURL>> entry : map.entrySet()) {
            int n2 = entry.getValue().size();
            double d2 = MathUtil.getPercent100((double)list.size(), (double)n2);
            arrayList.add(new AnchorUrlResult(entry.getKey(), n2, d2));
            if (!bl) continue;
        }
        Collections.sort(arrayList, BacklinkAnalyzeUtil::b);
        return arrayList;
    }

    public static List<AnchorUrlResult> getDomainsTopAnchorUrls(List<AnalyzeRecord> list) {
        boolean bl = CollectBackLinksCompositeOperation.c;
        ArrayList<AnchorUrlResult> arrayList = new ArrayList<AnchorUrlResult>();
        Map<UnicodeURL, List<UnicodeURL>> map = BacklinkAnalyzeUtil.d(list);
        int n2 = BacklinkAnalyzeUtil.getUniqueDomainsCount(list);
        for (Map.Entry<UnicodeURL, List<UnicodeURL>> entry : map.entrySet()) {
            int n3 = BacklinkAnalyzeUtil.getUniqueHomepagesCount((Collection<UnicodeURL>)entry.getValue());
            double d2 = MathUtil.getPercent((int)100, (double)n2, (double)n3);
            arrayList.add(new AnchorUrlResult(entry.getKey(), n3, d2));
            if (!bl) continue;
        }
        Collections.sort(arrayList, BacklinkAnalyzeUtil::a);
        return arrayList;
    }

    private static Map<UnicodeURL, List<UnicodeURL>> d(List<AnalyzeRecord> list) {
        boolean bl = CollectBackLinksCompositeOperation.c;
        TreeMap<UnicodeURL, List<UnicodeURL>> treeMap = new TreeMap<UnicodeURL, List<UnicodeURL>>(BacklinkAnalyzeUtil::a);
        for (AnalyzeRecord analyzeRecord : list) {
            UnicodeURL unicodeURL = analyzeRecord.getAnchorUrl();
            if (unicodeURL == null && !bl) continue;
            ArrayList<UnicodeURL> arrayList = (ArrayList<UnicodeURL>)treeMap.get(unicodeURL);
            if (arrayList == null) {
                arrayList = new ArrayList<UnicodeURL>();
                treeMap.put(unicodeURL, arrayList);
            }
            arrayList.add(analyzeRecord.getPage());
            if (!bl) continue;
        }
        return treeMap;
    }

    private static String a(UnicodeURL unicodeURL) {
        return UnicodeURLUtil.removeTrailingSlash((String)UnicodeURLUtil.removeWWW((String)UnicodeURLUtil.removeProtocol((UnicodeURL)unicodeURL)));
    }

    public static int getUniqueHomepagesCount(Collection<UnicodeURL> collection) {
        boolean bl = CollectBackLinksCompositeOperation.c;
        HashSet<String> hashSet = new HashSet<String>();
        for (UnicodeURL unicodeURL : collection) {
            hashSet.add(UnicodeURLUtil.getHostWithoutWWW((UnicodeURL)unicodeURL).toLowerCase());
            if (!bl) continue;
        }
        return hashSet.size();
    }

    private static String a(LinkInfo linkInfo) {
        return StringUtil.removeBrakes((String)linkInfo.getName()).toLowerCase();
    }

    public static Collection<String> getUniqueKeywords(String string) {
        if ("".equals(string)) {
            return Collections.singletonList(string);
        }
        string = string.replaceAll(b[4], "");
        return StringUtil.getUniqueKeywords((String)string.toLowerCase());
    }

    public static DofollowNofollowDistribution getDofollowNofollowDistribution(List<AnalyzeRecord> list) {
        boolean bl = CollectBackLinksCompositeOperation.c;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (AnalyzeRecord analyzeRecord : list) {
            block16: {
                block19: {
                    block18: {
                        ScanStatus scanStatus;
                        block17: {
                            block15: {
                                ScanResult scanResult = analyzeRecord.getScanResult();
                                scanStatus = scanResult.getScanStatus();
                                if (scanStatus != ScanStatus.SCAN_STATUS_UNKNOWN) break block15;
                                ++n4;
                                if (!bl) break block16;
                            }
                            if (!scanStatus.isOkStatus()) break block17;
                            ++n2;
                            if (!bl) break block16;
                        }
                        if (scanStatus == ScanStatus.SCAN_STATUS_CHEATING_NOFOLLOW) break block18;
                        if (scanStatus != ScanStatus.SCAN_STATUS_NOINDEX_ROBOTS) break block19;
                    }
                    ++n3;
                    if (!bl) break block16;
                }
                ++n4;
            }
            if (!bl) continue;
        }
        double d2 = MathUtil.getPercent((double)list.size(), (double)n2);
        double d3 = MathUtil.getPercent((double)list.size(), (double)n3);
        double d4 = MathUtil.getPercent((double)list.size(), (double)n4);
        return new DofollowNofollowDistribution(n2, d2, n3, d3, n4, d4);
    }

    public static TextImageDistribution getTextImageDistribution(List<AnalyzeRecord> list) {
        boolean bl = CollectBackLinksCompositeOperation.c;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (AnalyzeRecord analyzeRecord : list) {
            block11: {
                block10: {
                    ScanResult scanResult = analyzeRecord.getScanResult();
                    LinkInfo linkInfo = scanResult.getLinkInfo();
                    if (linkInfo == null) {
                        ++n4;
                        if (!bl) continue;
                    }
                    AnchorType anchorType = linkInfo.getAnchorType();
                    if (anchorType != AnchorType.TEXT_LINK || linkInfo.getBanner() != null) break block10;
                    ++n2;
                    if (!bl) break block11;
                }
                ++n3;
            }
            if (!bl) continue;
        }
        double d2 = MathUtil.getPercent((double)list.size(), (double)n2);
        double d3 = MathUtil.getPercent((double)list.size(), (double)n3);
        double d4 = MathUtil.getPercent((double)list.size(), (double)n4);
        return new TextImageDistribution(n2, d2, n3, d3, n4, d4);
    }

    public static HomepageLinksDistribution getFromHomepageLinkingDomainsDistribution(List<AnalyzeRecord> list) {
        int n2 = BacklinkAnalyzeUtil.getUniqueDomainsCount(list);
        int n3 = BacklinkAnalyzeUtil.getHomepageLinkingDomainsCount(list);
        int n4 = n2 - n3;
        return new HomepageLinksDistribution(n2, n3, n4);
    }

    public static HomepageLinksDistribution getToHomepageVsToOtherBacklinksDistribution(List<AnalyzeRecord> list) {
        int n2 = list.size();
        int n3 = BacklinkAnalyzeUtil.getToHomepageAnchorCount(list, false);
        int n4 = BacklinkAnalyzeUtil.getToHomepageAnchorCount(list, true);
        return new HomepageLinksDistribution(n2, n3, n4);
    }

    public static List<AnalyzeRecord> getAcceptedBacklinks(SpyGlassProject spyGlassProject) {
        boolean bl = CollectBackLinksCompositeOperation.c;
        if (spyGlassProject == null) {
            throw new IllegalArgumentException(String.format(b[1], b[3], b[0], b[2]));
        }
        ArrayList<AnalyzeRecord> arrayList = new ArrayList<AnalyzeRecord>();
        Iterator iterator = spyGlassProject.getBackLinks().iterator();
        while (iterator.hasNext()) {
            AnalyzeRecord analyzeRecord = (AnalyzeRecord)iterator.next();
            ScanResult scanResult = analyzeRecord.getScanResult();
            ScanStatus scanStatus = scanResult.getScanStatus();
            if (scanStatus == ScanStatus.SCAN_STATUS_SITE_NOT_FOUND || scanStatus == ScanStatus.SCAN_STATUS_PAGE_NOT_FOUND || scanStatus == ScanStatus.SCAN_STATUS_LINK_NOT_FOUND) continue;
            if (spyGlassProject.getDisavowFacade().isDisavow(analyzeRecord.getPage()) && !bl) continue;
            arrayList.add(analyzeRecord);
            if (!bl) continue;
        }
        return arrayList;
    }

    public static List<PRDistribution> getPagesPRDistributions(List<AnalyzeRecord> list) {
        boolean bl = CollectBackLinksCompositeOperation.c;
        ArrayList<PRDistribution> arrayList = new ArrayList<PRDistribution>();
        Map<Integer, List<UnicodeURL>> map = BacklinkAnalyzeUtil.a((SearchEngineFactorType<Integer>)SearchEngineFactorsList.PAGE_GOOGLE_PR, list);
        if (map.isEmpty()) {
            return arrayList;
        }
        for (int i2 = -1; i2 <= 10; ++i2) {
            List<UnicodeURL> list2 = map.get(i2);
            if (list2 == null) {
                arrayList.add(new PRDistribution(i2));
                if (!bl) continue;
            }
            double d2 = MathUtil.getPercent100((double)list.size(), (double)list2.size());
            arrayList.add(new PRDistribution(i2, list2.size(), d2));
            if (!bl) continue;
        }
        return arrayList;
    }

    public static List<PRDistribution> getDomainsPRDistributions(List<AnalyzeRecord> list) {
        boolean bl = CollectBackLinksCompositeOperation.c;
        ArrayList<PRDistribution> arrayList = new ArrayList<PRDistribution>();
        Map<Integer, List<UnicodeURL>> map = BacklinkAnalyzeUtil.a((SearchEngineFactorType<Integer>)SearchEngineFactorsList.DOMAIN_GOOGLE_PR, list);
        if (map.isEmpty()) {
            return arrayList;
        }
        int n2 = BacklinkAnalyzeUtil.getUniqueDomainsCount(list);
        for (int i2 = -1; i2 <= 10; ++i2) {
            List<UnicodeURL> list2 = map.get(i2);
            if (list2 == null) {
                arrayList.add(new PRDistribution(i2));
                if (!bl) continue;
            }
            int n3 = BacklinkAnalyzeUtil.getUniqueHomepagesCount(list2);
            double d2 = MathUtil.getPercent100((double)n2, (double)n3);
            arrayList.add(new PRDistribution(i2, n3, d2));
            if (!bl) continue;
        }
        return arrayList;
    }

    private static Map<Integer, List<UnicodeURL>> a(SearchEngineFactorType<Integer> searchEngineFactorType, List<AnalyzeRecord> list) {
        boolean bl = CollectBackLinksCompositeOperation.c;
        HashMap<Integer, List<UnicodeURL>> hashMap = new HashMap<Integer, List<UnicodeURL>>();
        for (AnalyzeRecord analyzeRecord : list) {
            PopularityMap popularityMap = analyzeRecord.getRankingFactorsMap();
            SearchEngineFactor searchEngineFactor = popularityMap.getFactor(searchEngineFactorType);
            if (searchEngineFactor == null && !bl) continue;
            Integer n2 = (Integer)searchEngineFactor.getFactorValue();
            ArrayList<UnicodeURL> arrayList = (ArrayList<UnicodeURL>)hashMap.get(n2);
            if (arrayList == null) {
                arrayList = new ArrayList<UnicodeURL>();
                hashMap.put(n2, arrayList);
            }
            arrayList.add(analyzeRecord.getPage());
            if (!bl) continue;
        }
        return hashMap;
    }

    public static NavigableMap<Date, Integer> getBacklinksIndexByDate(List<AnalyzeRecord> list) {
        ImmutableListMultimap immutableListMultimap = FluentIterable.from(list).filter((Predicate)new r()).index((Function)new q());
        return Maps.transformValues(new TreeMap(immutableListMultimap.asMap()), Collection::size);
    }

    public static NavigableMap<Date, Integer> getDomainsIndexByDate(List<AnalyzeRecord> list) {
        Comparable<Date> comparable;
        boolean bl = CollectBackLinksCompositeOperation.c;
        ImmutableMap immutableMap = Multimaps.index(list, (Function)new s()).asMap();
        NavigableMap navigableMap = Maps.transformValues(new TreeMap(immutableMap), (Function)new t());
        TreeMap<Object, Date> treeMap = new TreeMap<Object, Date>();
        for (AnalyzeRecord object : list) {
            block12: {
                Date date;
                Object object2;
                block13: {
                    object2 = UnicodeURLUtil.getHostWithoutWWW((UnicodeURL)object.getPage()).toLowerCase();
                    comparable = (Date)treeMap.get(object2);
                    date = DateUtil.getUtcStartDay((Date)object.getFirstFoundDate());
                    if (date == null) break block12;
                    if (comparable == null) break block13;
                    if (((Date)comparable).getTime() <= date.getTime()) break block12;
                }
                treeMap.put(object2, date);
            }
            if (!bl) continue;
        }
        TreeMap treeMap2 = new TreeMap();
        for (Object object2 : navigableMap.values()) {
            comparable = (Integer)treeMap2.get(object2);
            if (comparable == null) {
                comparable = 0;
            }
            if (object2 != null) {
                treeMap2.put(object2, (Integer)comparable + 1);
            }
            if (!bl) continue;
        }
        return treeMap2;
    }

    private static int a(UnicodeURL unicodeURL, UnicodeURL unicodeURL2) {
        return BacklinkAnalyzeUtil.a(unicodeURL).compareToIgnoreCase(BacklinkAnalyzeUtil.a(unicodeURL2));
    }

    private static int a(AnchorUrlResult anchorUrlResult, AnchorUrlResult anchorUrlResult2) {
        return anchorUrlResult2.getCount() - anchorUrlResult.getCount();
    }

    private static int b(AnchorUrlResult anchorUrlResult, AnchorUrlResult anchorUrlResult2) {
        return anchorUrlResult2.getCount() - anchorUrlResult.getCount();
    }

    private static int a(TLDResult tLDResult, TLDResult tLDResult2) {
        return tLDResult2.getDomainsCount() - tLDResult.getDomainsCount();
    }

    private static int a(CountryResult countryResult, CountryResult countryResult2) {
        return countryResult2.getDomainsCount() - countryResult.getDomainsCount();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block28: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block27: {
                String string;
                String[] stringArray = new String[5];
                String[] stringArray2 = stringArray;
                String[] stringArray3 = stringArray;
                int n5 = 0;
                String string2 = "4\u001c\u0010#30\u001a\u0011i?>\u001d\u0019#!'\n\u001a`3$\u0000Ry&>\u001fRN34\u0018\u0011e<<2\u0013m>.\t\u0018Y&>\u001f";
                int n6 = -1;
                block18: while (true) {
                    char[] cArray3;
                    block26: {
                        int n7;
                        int n8;
                        char[] cArray4;
                        block25: {
                            char[] cArray5 = string2.toCharArray();
                            n4 = 0;
                            int n9 = cArray5.length;
                            cArray4 = cArray5;
                            n8 = n9;
                            if (n9 <= 1) break block25;
                            cArray3 = cArray4;
                            n7 = n8;
                            if (n8 <= n4) break block26;
                        }
                        do {
                            char[] cArray6 = cArray4;
                            char[] cArray7 = cArray4;
                            int n10 = n4;
                            while (true) {
                                int n11;
                                char c2 = cArray6[n10];
                                switch (n4 % 5) {
                                    case 0: {
                                        n11 = 87;
                                        break;
                                    }
                                    case 1: {
                                        n11 = 115;
                                        break;
                                    }
                                    case 2: {
                                        n11 = 125;
                                        break;
                                    }
                                    case 3: {
                                        n11 = 12;
                                        break;
                                    }
                                    default: {
                                        n11 = 82;
                                    }
                                }
                                cArray6[n10] = (char)(c2 ^ n11);
                                ++n4;
                                cArray4 = cArray7;
                                n8 = n8;
                                if (n8 != 0) break;
                                cArray7 = cArray4;
                                n7 = n8;
                                n10 = n8;
                                cArray6 = cArray4;
                            }
                            cArray3 = cArray4;
                            n7 = n8;
                        } while (n8 > n4);
                    }
                    string = new String(cArray3);
                    switch (n6) {
                        default: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 1;
                            string2 = "\u0016\u0001\u001ay?2\u001d\t,48\u0001]L\u001c8\u00073y>;S\rm 6\u001e\u0018x7%SZ)!pS\u0012jrr\u0000S)!w\u001e\b\u007f&w\u001d\u0012xr5\u0016]b';\u001f";
                            n6 = 0;
                            continue block18;
                        }
                        case 0: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 2;
                            string2 = "0\u0016\tM14\u0016\rx731\u001co9;\u001a\u0013g!";
                            n6 = 1;
                            continue block18;
                        }
                        case 1: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 3;
                            string2 = "'\u0001\u0012f74\u0007";
                            n6 = 2;
                            continue block18;
                        }
                        case 2: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 4;
                            string2 = "\fRB \u000f";
                            n6 = 3;
                            continue block18;
                        }
                        case 3: 
                    }
                    break;
                }
                stringArray2[n5] = string.intern();
                b = stringArray3;
                char[] cArray8 = "\t[UWbf.BP6\u000b\u0017Bp`\fCP8\u000f\u000b\u0017\u0001>g\fCP9\u000f~/S%)d\u000eUWbf.BP6\u000b\u0017Bp`\fCP8\u000f\u000b\u0017\u0001>g\fCP9\u000f~W".toCharArray();
                n4 = 0;
                int n12 = cArray8.length;
                cArray2 = cArray8;
                n3 = n12;
                if (n12 <= 1) break block27;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block28;
            }
            do {
                char[] cArray9 = cArray2;
                char[] cArray10 = cArray2;
                int n13 = n4;
                while (true) {
                    int n14;
                    char c3 = cArray9[n13];
                    switch (n4 % 5) {
                        case 0: {
                            n14 = 87;
                            break;
                        }
                        case 1: {
                            n14 = 115;
                            break;
                        }
                        case 2: {
                            n14 = 125;
                            break;
                        }
                        case 3: {
                            n14 = 12;
                            break;
                        }
                        default: {
                            n14 = 82;
                        }
                    }
                    cArray9[n13] = (char)(c3 ^ n14);
                    ++n4;
                    cArray2 = cArray10;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray10 = cArray2;
                    n2 = n3;
                    n13 = n3;
                    cArray9 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        a = Pattern.compile(new String(cArray).intern());
    }
}

