/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.spyglass.util;

import com.agilemind.spyglass.data.AnalyzeRecord;
import com.agilemind.spyglass.data.BacklinkStatus;
import com.agilemind.spyglass.data.SpyGlassProject;
import com.agilemind.spyglass.data.StatisticsMode;
import com.agilemind.spyglass.data.statistics.StatisticsRecord;
import com.agilemind.spyglass.util.BackLinkAnalyzeResultApply;
import com.agilemind.spyglass.util.CollectBackLinksCompositeOperation;
import com.agilemind.spyglass.util.CollectBackLinksResult;
import com.agilemind.spyglass.util.LinkingDomainAnalyzeResultApply;
import com.agilemind.spyglass.util.updater.BackLinkUpdaterFactory;
import java.util.List;

public class CollectBackLinksResultApply {
    private BackLinkAnalyzeResultApply a;
    private LinkingDomainAnalyzeResultApply b;

    public CollectBackLinksResultApply(BackLinkUpdaterFactory backLinkUpdaterFactory, boolean bl) {
        this.a = new BackLinkAnalyzeResultApply(backLinkUpdaterFactory, bl);
        this.b = new LinkingDomainAnalyzeResultApply();
    }

    public void apply(List<CollectBackLinksResult> list) {
        boolean bl = CollectBackLinksCompositeOperation.c;
        for (CollectBackLinksResult collectBackLinksResult : list) {
            if (collectBackLinksResult == null && !bl) continue;
            SpyGlassProject spyGlassProject = collectBackLinksResult.getProject();
            StatisticsRecord statisticsRecord = spyGlassProject.getStatistics();
            if (spyGlassProject.getStatisticsMode() == null) {
                spyGlassProject.setStatisticsMode(this.a(statisticsRecord.getTotalBacklinkCount(), collectBackLinksResult.getBackLinkAnalyzeResults().size()));
            }
            spyGlassProject.getBackLinks().stream().forEach(this::a);
            this.a.apply(spyGlassProject, collectBackLinksResult.getBackLinkAnalyzeResults());
            this.b.apply(spyGlassProject, collectBackLinksResult.getLinkingDomainAnalyzeResults());
            if (!bl) continue;
        }
    }

    private void a(AnalyzeRecord analyzeRecord) {
        if (analyzeRecord.getBacklinkStatus() == BacklinkStatus.NEW) {
            analyzeRecord.setBacklinkStatus(BacklinkStatus.ALREADY_EXIST);
        }
    }

    private StatisticsMode a(int n2, int n3) {
        if (n3 > n2) {
            return StatisticsMode.PROJECT;
        }
        return StatisticsMode.BLEX;
    }
}

