/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.spyglass.util.export;

import com.agilemind.commons.io.backlink.BackLinkQueryBuilder;
import com.agilemind.commons.io.backlink.BackLinkSourceList;
import com.agilemind.commons.io.backlink.BackLinkSourceType;
import com.agilemind.commons.io.backlink.IBackLinkSourceSettings;
import com.agilemind.spyglass.util.export.BackLinkExporter;
import com.agilemind.spyglass.util.export.BackLinkExporterFactory;
import com.agilemind.spyglass.util.export.BackLinkSourceExporter;
import com.agilemind.spyglass.util.export.BlexBackLinkExporter;
import com.agilemind.spyglass.util.export.GoogleSearchConsoleBackLinkExporter;
import com.agilemind.spyglass.util.export.convert.BackLinkToRecordsConvert;
import com.agilemind.spyglass.util.export.convert.BackLinkToRecordsConvertFactory;
import com.agilemind.spyglass.util.query.BackLinkQueryBuilderFactory;

public class DefaultBackLinkExporterFactory
implements BackLinkExporterFactory {
    private IBackLinkSourceSettings a;
    private BackLinkToRecordsConvertFactory b;
    private BackLinkQueryBuilderFactory c;

    public DefaultBackLinkExporterFactory(BackLinkQueryBuilderFactory backLinkQueryBuilderFactory, IBackLinkSourceSettings iBackLinkSourceSettings, BackLinkToRecordsConvertFactory backLinkToRecordsConvertFactory) {
        this.c = backLinkQueryBuilderFactory;
        this.a = iBackLinkSourceSettings;
        this.b = backLinkToRecordsConvertFactory;
    }

    @Override
    public BackLinkExporter createBackLinkExporter(BackLinkSourceType backLinkSourceType) {
        if (backLinkSourceType == BackLinkSourceList.WEBMEUP_BACKLINK_SOURCE_TYPE) {
            return new BlexBackLinkExporter();
        }
        if (backLinkSourceType == BackLinkSourceList.GOOGLE_SEARCH_CONSOLE_BACKLINK_SOURCE) {
            return new GoogleSearchConsoleBackLinkExporter(this.a.getGoogleSearchConsoleSettings());
        }
        BackLinkQueryBuilder backLinkQueryBuilder = this.c.getBackLinkQueryBuilder(backLinkSourceType);
        BackLinkToRecordsConvert backLinkToRecordsConvert = this.b.createBackLinkToRecordsConvert(backLinkSourceType);
        return new BackLinkSourceExporter(backLinkSourceType, backLinkQueryBuilder, this.a, backLinkToRecordsConvert);
    }
}

