/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.auditcommon.crawler;

import com.agilemind.auditcommon.crawler.OrphanSource;
import com.agilemind.auditcommon.crawler.ResourceType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public interface ISiteCrawlingSettings {
    public static final String CUSTOM_VALUE;

    public boolean isUseCustomRobotsInstruction();

    public boolean isUseRobotInstruction();

    public boolean isUseDepthLimit();

    public boolean isUseUserAgent();

    public boolean isUseIncludeFilter();

    public boolean isUseExcludeFilter();

    public boolean isUseRequestLimit();

    public boolean isIgnoreUrlParameters();

    public boolean isUseAllUrlParameters();

    @NotNull
    public Iterable<String> getIgnoredUrlParameters();

    default public boolean isIgnoreAllParameters() {
        return this.isIgnoreUrlParameters() && this.isUseAllUrlParameters();
    }

    default public boolean isIgnoreParametersList() {
        return this.isIgnoreUrlParameters() && !this.isUseAllUrlParameters();
    }

    default public boolean isNotIgnoreParameters() {
        return !this.isIgnoreUrlParameters();
    }

    default public String getRobotsInstruction() {
        return this.isUseCustomRobotsInstruction() ? this.getCustomRobotsInstruction() : this.getPredefinedRobotsInstruction();
    }

    public String getCustomRobotsInstruction();

    public String getPredefinedRobotsInstruction();

    public String getUserAgent();

    public int getClickDepthLimit();

    default public int getRedirectDepthLimit() {
        return 22;
    }

    public int getRequestsPerIntervalCount();

    public int getIntervalSecond();

    @NotNull
    public Collection<String> getIncludeFilters();

    @NotNull
    public Collection<String> getExcludeFilters();

    public boolean isUseSubDomain();

    default public double getRequestPerSecond() {
        return (double)this.getRequestsPerIntervalCount() / (double)this.getIntervalSecond();
    }

    public boolean isAddToPageDisallowedRobotsPage();

    public boolean isUpdateClickDepth();

    public boolean isUseInternalBrowser();

    public boolean isUseAuthenticate();

    public String getUsername();

    public String getPassword();

    public boolean isUseSearchOrphan();

    public Collection<OrphanSource> getOrphanSources();

    @NotNull
    public Collection<ResourceType> getWebResources();

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "-\u001beh\u0011\u0003".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 110;
                            break;
                        }
                        case 1: {
                            n7 = 110;
                            break;
                        }
                        case 2: {
                            n7 = 22;
                            break;
                        }
                        case 3: {
                            n7 = 28;
                            break;
                        }
                        default: {
                            n7 = 126;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        CUSTOM_VALUE = new String(cArray).intern();
    }
}

