/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.websiteauditor.audit.recommendation;

import com.agilemind.commons.application.modules.audit.page.PageAuditFactorType;
import com.agilemind.commons.application.modules.audit.page.PageContentFactorType;
import com.agilemind.commons.application.modules.audit.page.PageTechnicalFactorType;
import com.agilemind.commons.application.modules.audit.page.onpage.common.PageContentAuditFactorList;
import com.agilemind.websiteauditor.audit.IPageAuditRecommendationFactory;
import com.agilemind.websiteauditor.audit.PageAuditRecommendation;
import com.agilemind.websiteauditor.audit.page.technical.common.PageTechnicalAuditFactorList;
import com.agilemind.websiteauditor.audit.recommendation.DefaultPageAuditRecommendation;
import com.agilemind.websiteauditor.audit.recommendation.KeywordsInAltTextRecommendation;
import com.agilemind.websiteauditor.audit.recommendation.KeywordsInBodyRecommendation;
import com.agilemind.websiteauditor.audit.recommendation.KeywordsInH1Recommendation;
import com.agilemind.websiteauditor.audit.recommendation.KeywordsInLinkAnchorsRecommendation;
import com.agilemind.websiteauditor.audit.recommendation.KeywordsInMetaDescriptionRecommendation;
import com.agilemind.websiteauditor.audit.recommendation.KeywordsInMetaKwsRecommendation;
import com.agilemind.websiteauditor.audit.recommendation.KeywordsInTagRecommendation;
import com.agilemind.websiteauditor.audit.recommendation.MetaDescLengthRecommendation;
import com.agilemind.websiteauditor.audit.recommendation.MobileFriendlyRecommendation;
import com.agilemind.websiteauditor.audit.recommendation.NumberFallOutsideAuditRecommendation;
import com.agilemind.websiteauditor.audit.recommendation.OpenGraphRecommendation;
import com.agilemind.websiteauditor.audit.recommendation.PageStatusCodeRecommendation;
import com.agilemind.websiteauditor.audit.recommendation.PagesWithMetaRefreshRecommendation;
import com.agilemind.websiteauditor.audit.recommendation.PagesWithRelCanonicalRecommendation;
import com.agilemind.websiteauditor.audit.recommendation.RedirectsPageAuditRecommendation;
import com.agilemind.websiteauditor.audit.recommendation.RestrictedFromIndexingRecommendation;
import com.agilemind.websiteauditor.audit.recommendation.StructuredDataMarkupRecommendation;
import com.agilemind.websiteauditor.audit.recommendation.TitleLengthRecommendation;
import com.agilemind.websiteauditor.audit.recommendation.UncompressedResourceRecommendation;
import com.agilemind.websiteauditor.audit.recommendation.ViewportIsConfiguredRecommendation;
import com.agilemind.websiteauditor.audit.recommendation.VisibleContentPrioritizedRecommendation;
import com.agilemind.websiteauditor.audit.recommendation.W3CCssValidationRecommendation;
import com.agilemind.websiteauditor.audit.recommendation.W3CHtmlValidationRecommendation;
import com.agilemind.websiteauditor.audit.recommendation.WordCountInBodyRecommendation;
import com.agilemind.websiteauditor.data.WebsiteAuditorPage;

public class PageAuditRecommendationFactory
implements IPageAuditRecommendationFactory {
    private WebsiteAuditorPage a;

    public PageAuditRecommendationFactory(WebsiteAuditorPage websiteAuditorPage) {
        this.a = websiteAuditorPage;
    }

    @Override
    public PageAuditRecommendation getPageAuditRecommendation(PageAuditFactorType pageAuditFactorType) {
        if (PageContentAuditFactorList.isOnePage((PageAuditFactorType)pageAuditFactorType)) {
            PageContentFactorType pageContentFactorType = (PageContentFactorType)pageAuditFactorType;
            switch (pageContentFactorType) {
                case KEYWORDS_IN_TITLE: {
                    return new KeywordsInTagRecommendation(pageAuditFactorType);
                }
                case KEYWORDS_IN_META_DESCRIPTION: {
                    return new KeywordsInMetaDescriptionRecommendation();
                }
                case KEYWORDS_IN_BODY: {
                    return new KeywordsInBodyRecommendation();
                }
                case TITLE_LENGTH: {
                    return new TitleLengthRecommendation();
                }
                case META_DESCRIPTION_LENGTH: {
                    return new MetaDescLengthRecommendation();
                }
                case KEYWORDS_IN_META_KWS: {
                    return new KeywordsInMetaKwsRecommendation();
                }
                case WORD_COUNT_IN_BODY: {
                    return new WordCountInBodyRecommendation();
                }
                case KEYWORDS_IN_H1: {
                    return new KeywordsInH1Recommendation();
                }
                case KEYWORDS_IN_H2H6: 
                case KEYWORDS_IN_BOLD: 
                case KEYWORDS_IN_ITALIC: 
                case KEYWORDS_IN_LINK_ANCHORS: {
                    return new KeywordsInLinkAnchorsRecommendation(pageAuditFactorType);
                }
                case KEYWORDS_IN_ALT_TEXT: {
                    return new KeywordsInAltTextRecommendation();
                }
                case OPEN_GRAPH: {
                    return new OpenGraphRecommendation();
                }
                case STRUCTURED_DATA_MARKUP_TEC: {
                    return new StructuredDataMarkupRecommendation(this.a);
                }
            }
            return new DefaultPageAuditRecommendation(pageAuditFactorType);
        }
        if (PageTechnicalAuditFactorList.isTechnical(pageAuditFactorType)) {
            PageTechnicalFactorType pageTechnicalFactorType = (PageTechnicalFactorType)pageAuditFactorType;
            switch (pageTechnicalFactorType) {
                case PAGE_STATUS_CODE: {
                    return new PageStatusCodeRecommendation();
                }
                case PAGE_RESTRICTED_FROM_INDEXING: {
                    return new RestrictedFromIndexingRecommendation();
                }
                case PAGE_USES_META_REFRESH: {
                    return new PagesWithMetaRefreshRecommendation();
                }
                case W3C_CSS_ERRORS_WARNINGS: {
                    return new W3CCssValidationRecommendation(this.a);
                }
                case W3C_HTML_ERRORS_WARNINGS: {
                    return new W3CHtmlValidationRecommendation(this.a);
                }
                case PAGE_USES_REL_CANONICAL: {
                    return new PagesWithRelCanonicalRecommendation();
                }
                case PAGE_MANY_REDIRECTS: {
                    return new RedirectsPageAuditRecommendation(this.a);
                }
                case NUMBER_UNCOMPRESSED_RESOURCES: 
                case NUMBER_UNCOMPRESSED_IMAGES: 
                case NUMBER_RESOURCES_NOT_MINIFIED: {
                    return new UncompressedResourceRecommendation(this.a, pageAuditFactorType);
                }
                case VISIBLE_CONTENT_IS_PRIORITIZED: {
                    return new VisibleContentPrioritizedRecommendation();
                }
                case MOBILE_FRIENDLY: {
                    return new MobileFriendlyRecommendation(this.a);
                }
                case VIEWPORT_IS_CONFIGURED: {
                    return new ViewportIsConfiguredRecommendation();
                }
                case NUMBER_FALL_OUTSIDE_VIEWPORT: {
                    return new NumberFallOutsideAuditRecommendation();
                }
            }
            return new DefaultPageAuditRecommendation(pageAuditFactorType);
        }
        return new DefaultPageAuditRecommendation(pageAuditFactorType);
    }
}

